/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>MQTT Security</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * MQTT-specific security configuration.
 * 
 * Extends the base security configuration with MQTT-specific settings including client certificates and protocol versions.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#getClientCertPath <em>Client Cert Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#getTlsVersion <em>Tls Version</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#isInsecureSkipVerify <em>Insecure Skip Verify</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTSecurity()
 * @model
 * @generated
 */
@ProviderType
public interface MQTTSecurity extends Security {
	/**
	 * Returns the value of the '<em><b>Client Cert Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Path to client certificate file.
	 * 
	 * Used for client certificate authentication in mutual TLS.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Client Cert Path</em>' attribute.
	 * @see #setClientCertPath(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTSecurity_ClientCertPath()
	 * @model
	 * @generated
	 */
	String getClientCertPath();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#getClientCertPath <em>Client Cert Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Client Cert Path</em>' attribute.
	 * @see #getClientCertPath()
	 * @generated
	 */
	void setClientCertPath(String value);

	/**
	 * Returns the value of the '<em><b>Tls Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * TLS protocol version to use.
	 * 
	 * Specifies the TLS version (e.g., 'TLSv1.2', 'TLSv1.3').
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Tls Version</em>' attribute.
	 * @see #setTlsVersion(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTSecurity_TlsVersion()
	 * @model
	 * @generated
	 */
	String getTlsVersion();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#getTlsVersion <em>Tls Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tls Version</em>' attribute.
	 * @see #getTlsVersion()
	 * @generated
	 */
	void setTlsVersion(String value);

	/**
	 * Returns the value of the '<em><b>Insecure Skip Verify</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to skip certificate verification.
	 * 
	 * If true, certificate verification will be skipped (not recommended for production).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Insecure Skip Verify</em>' attribute.
	 * @see #setInsecureSkipVerify(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTSecurity_InsecureSkipVerify()
	 * @model default="false"
	 * @generated
	 */
	boolean isInsecureSkipVerify();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#isInsecureSkipVerify <em>Insecure Skip Verify</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Insecure Skip Verify</em>' attribute.
	 * @see #isInsecureSkipVerify()
	 * @generated
	 */
	void setInsecureSkipVerify(boolean value);

} // MQTTSecurity
