/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage
 * @generated
 */
@ProviderType
public interface NGSIProtocolsFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	NGSIProtocolsFactory eINSTANCE = org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>HTTP Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>HTTP Configuration</em>'.
	 * @generated
	 */
	HTTPConfiguration createHTTPConfiguration();

	/**
	 * Returns a new object of class '<em>MQTT Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MQTT Configuration</em>'.
	 * @generated
	 */
	MQTTConfiguration createMQTTConfiguration();

	/**
	 * Returns a new object of class '<em>Web Socket Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Web Socket Configuration</em>'.
	 * @generated
	 */
	WebSocketConfiguration createWebSocketConfiguration();

	/**
	 * Returns a new object of class '<em>Kafka Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Kafka Configuration</em>'.
	 * @generated
	 */
	KafkaConfiguration createKafkaConfiguration();

	/**
	 * Returns a new object of class '<em>AMQP Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>AMQP Configuration</em>'.
	 * @generated
	 */
	AMQPConfiguration createAMQPConfiguration();

	/**
	 * Returns a new object of class '<em>HTTP Security</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>HTTP Security</em>'.
	 * @generated
	 */
	HTTPSecurity createHTTPSecurity();

	/**
	 * Returns a new object of class '<em>MQTT Security</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MQTT Security</em>'.
	 * @generated
	 */
	MQTTSecurity createMQTTSecurity();

	/**
	 * Returns a new object of class '<em>Kafka Security</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Kafka Security</em>'.
	 * @generated
	 */
	KafkaSecurity createKafkaSecurity();

	/**
	 * Returns a new object of class '<em>HTTP Header</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>HTTP Header</em>'.
	 * @generated
	 */
	HTTPHeader createHTTPHeader();

	/**
	 * Returns a new object of class '<em>Kafka Property</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Kafka Property</em>'.
	 * @generated
	 */
	KafkaProperty createKafkaProperty();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	NGSIProtocolsPackage getNGSIProtocolsPackage();

} //NGSIProtocolsFactory
