/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.ngsi.NGSIPackage;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * NGSI-LD Protocol Extension Model
 * 
 * This model provides concrete implementations of protocol configurations for NGSI-LD notifications. It extends the abstract protocol configuration defined in the NGSI-LD wrapper model with specific implementations for HTTP, MQTT, WebSocket, Kafka, and AMQP protocols.
 * 
 * Supports multi-protocol notification delivery with security and reliability features.
 * <!-- end-model-doc -->
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsFactory
 * @model kind="package"
 * @generated
 */
@ProviderType
@EPackage(uri = NGSIProtocolsPackage.eNS_URI, genModel = "/model/ngsi.genmodel", genModelSourceLocations = {"model/ngsi.genmodel","org.gecko.emf.ngsi/model/ngsi.genmodel"}, ecore="/model/ngsi-protocols.ecore", ecoreSourceLocations="/model/ngsi-protocols.ecore")
public interface NGSIProtocolsPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "protocols";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "https://uri.etsi.org/ngsi-ld/protocol/v1/";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "proto";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	NGSIProtocolsPackage eINSTANCE = org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl <em>HTTP Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPConfiguration()
	 * @generated
	 */
	int HTTP_CONFIGURATION = 0;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION__URL = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION__METHOD = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION__HEADERS = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Follow Redirects</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION__FOLLOW_REDIRECTS = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Content Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION__CONTENT_TYPE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION__SECURITY = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>HTTP Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION_FEATURE_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>HTTP Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_CONFIGURATION_OPERATION_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl <em>MQTT Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getMQTTConfiguration()
	 * @generated
	 */
	int MQTT_CONFIGURATION = 1;

	/**
	 * The feature id for the '<em><b>Broker</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__BROKER = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__PORT = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Topic</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__TOPIC = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Qos</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__QOS = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Retain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__RETAIN = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Client Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__CLIENT_ID = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Clean Session</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__CLEAN_SESSION = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Keep Alive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__KEEP_ALIVE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION__SECURITY = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>MQTT Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION_FEATURE_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>MQTT Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_CONFIGURATION_OPERATION_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl <em>Web Socket Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getWebSocketConfiguration()
	 * @generated
	 */
	int WEB_SOCKET_CONFIGURATION = 2;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION__URL = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Subprotocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION__SUBPROTOCOL = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ping Interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION__PING_INTERVAL = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Max Frame Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION__HEADERS = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION__SECURITY = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Web Socket Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION_FEATURE_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Web Socket Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SOCKET_CONFIGURATION_OPERATION_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl <em>Kafka Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaConfiguration()
	 * @generated
	 */
	int KAFKA_CONFIGURATION = 3;

	/**
	 * The feature id for the '<em><b>Bootstrap Servers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Topic</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__TOPIC = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Partition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__PARTITION = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__KEY = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Compression Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__COMPRESSION_TYPE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Acks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__ACKS = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__PROPERTIES = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION__SECURITY = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Kafka Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION_FEATURE_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Kafka Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_CONFIGURATION_OPERATION_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl <em>AMQP Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getAMQPConfiguration()
	 * @generated
	 */
	int AMQP_CONFIGURATION = 4;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__HOST = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__PORT = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Virtual Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__VIRTUAL_HOST = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Exchange</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__EXCHANGE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Routing Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__ROUTING_KEY = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Queue</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__QUEUE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Durable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__DURABLE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Auto Delete</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__AUTO_DELETE = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION__SECURITY = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>AMQP Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION_FEATURE_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>AMQP Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMQP_CONFIGURATION_OPERATION_COUNT = NGSIPackage.PROTOCOL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl <em>Security</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.SecurityImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getSecurity()
	 * @generated
	 */
	int SECURITY = 5;

	/**
	 * The feature id for the '<em><b>Username</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__USERNAME = 0;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__PASSWORD = 1;

	/**
	 * The feature id for the '<em><b>Keystore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__KEYSTORE_PATH = 2;

	/**
	 * The feature id for the '<em><b>Key Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__KEY_PATH = 3;

	/**
	 * The feature id for the '<em><b>Keystore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__KEYSTORE_PASSWORD = 4;

	/**
	 * The feature id for the '<em><b>Truststore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__TRUSTSTORE_PATH = 5;

	/**
	 * The feature id for the '<em><b>Truststore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__TRUSTSTORE_PASSWORD = 6;

	/**
	 * The feature id for the '<em><b>Use SSL</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY__USE_SSL = 7;

	/**
	 * The number of structural features of the '<em>Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECURITY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl <em>HTTP Security</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPSecurity()
	 * @generated
	 */
	int HTTP_SECURITY = 6;

	/**
	 * The feature id for the '<em><b>Username</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__USERNAME = SECURITY__USERNAME;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__PASSWORD = SECURITY__PASSWORD;

	/**
	 * The feature id for the '<em><b>Keystore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__KEYSTORE_PATH = SECURITY__KEYSTORE_PATH;

	/**
	 * The feature id for the '<em><b>Key Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__KEY_PATH = SECURITY__KEY_PATH;

	/**
	 * The feature id for the '<em><b>Keystore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__KEYSTORE_PASSWORD = SECURITY__KEYSTORE_PASSWORD;

	/**
	 * The feature id for the '<em><b>Truststore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__TRUSTSTORE_PATH = SECURITY__TRUSTSTORE_PATH;

	/**
	 * The feature id for the '<em><b>Truststore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__TRUSTSTORE_PASSWORD = SECURITY__TRUSTSTORE_PASSWORD;

	/**
	 * The feature id for the '<em><b>Use SSL</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__USE_SSL = SECURITY__USE_SSL;

	/**
	 * The feature id for the '<em><b>Auth Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__AUTH_TYPE = SECURITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bearer Token</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__BEARER_TOKEN = SECURITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Api Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__API_KEY = SECURITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Api Key Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__API_KEY_HEADER = SECURITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Verify Hostname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY__VERIFY_HOSTNAME = SECURITY_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>HTTP Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY_FEATURE_COUNT = SECURITY_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>HTTP Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_SECURITY_OPERATION_COUNT = SECURITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.MQTTSecurityImpl <em>MQTT Security</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.MQTTSecurityImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getMQTTSecurity()
	 * @generated
	 */
	int MQTT_SECURITY = 7;

	/**
	 * The feature id for the '<em><b>Username</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__USERNAME = SECURITY__USERNAME;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__PASSWORD = SECURITY__PASSWORD;

	/**
	 * The feature id for the '<em><b>Keystore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__KEYSTORE_PATH = SECURITY__KEYSTORE_PATH;

	/**
	 * The feature id for the '<em><b>Key Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__KEY_PATH = SECURITY__KEY_PATH;

	/**
	 * The feature id for the '<em><b>Keystore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__KEYSTORE_PASSWORD = SECURITY__KEYSTORE_PASSWORD;

	/**
	 * The feature id for the '<em><b>Truststore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__TRUSTSTORE_PATH = SECURITY__TRUSTSTORE_PATH;

	/**
	 * The feature id for the '<em><b>Truststore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__TRUSTSTORE_PASSWORD = SECURITY__TRUSTSTORE_PASSWORD;

	/**
	 * The feature id for the '<em><b>Use SSL</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__USE_SSL = SECURITY__USE_SSL;

	/**
	 * The feature id for the '<em><b>Client Cert Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__CLIENT_CERT_PATH = SECURITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tls Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__TLS_VERSION = SECURITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Insecure Skip Verify</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY__INSECURE_SKIP_VERIFY = SECURITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>MQTT Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY_FEATURE_COUNT = SECURITY_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>MQTT Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MQTT_SECURITY_OPERATION_COUNT = SECURITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.KafkaSecurityImpl <em>Kafka Security</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.KafkaSecurityImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaSecurity()
	 * @generated
	 */
	int KAFKA_SECURITY = 8;

	/**
	 * The feature id for the '<em><b>Username</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__USERNAME = SECURITY__USERNAME;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__PASSWORD = SECURITY__PASSWORD;

	/**
	 * The feature id for the '<em><b>Keystore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__KEYSTORE_PATH = SECURITY__KEYSTORE_PATH;

	/**
	 * The feature id for the '<em><b>Key Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__KEY_PATH = SECURITY__KEY_PATH;

	/**
	 * The feature id for the '<em><b>Keystore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__KEYSTORE_PASSWORD = SECURITY__KEYSTORE_PASSWORD;

	/**
	 * The feature id for the '<em><b>Truststore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__TRUSTSTORE_PATH = SECURITY__TRUSTSTORE_PATH;

	/**
	 * The feature id for the '<em><b>Truststore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__TRUSTSTORE_PASSWORD = SECURITY__TRUSTSTORE_PASSWORD;

	/**
	 * The feature id for the '<em><b>Use SSL</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__USE_SSL = SECURITY__USE_SSL;

	/**
	 * The feature id for the '<em><b>Security Protocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__SECURITY_PROTOCOL = SECURITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sasl Mechanism</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__SASL_MECHANISM = SECURITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sasl Jaas Config</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY__SASL_JAAS_CONFIG = SECURITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Kafka Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY_FEATURE_COUNT = SECURITY_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Kafka Security</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_SECURITY_OPERATION_COUNT = SECURITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.HTTPHeaderImpl <em>HTTP Header</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.HTTPHeaderImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPHeader()
	 * @generated
	 */
	int HTTP_HEADER = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_HEADER__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_HEADER__VALUE = 1;

	/**
	 * The number of structural features of the '<em>HTTP Header</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_HEADER_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>HTTP Header</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HTTP_HEADER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.impl.KafkaPropertyImpl <em>Kafka Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.impl.KafkaPropertyImpl
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaProperty()
	 * @generated
	 */
	int KAFKA_PROPERTY = 10;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_PROPERTY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_PROPERTY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Kafka Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_PROPERTY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Kafka Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAFKA_PROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.HTTPMethod <em>HTTP Method</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.HTTPMethod
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPMethod()
	 * @generated
	 */
	int HTTP_METHOD = 11;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.HTTPAuthType <em>HTTP Auth Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.HTTPAuthType
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPAuthType()
	 * @generated
	 */
	int HTTP_AUTH_TYPE = 12;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.MQTTQoS <em>MQTT Qo S</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.MQTTQoS
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getMQTTQoS()
	 * @generated
	 */
	int MQTT_QO_S = 13;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.KafkaCompressionType <em>Kafka Compression Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.KafkaCompressionType
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaCompressionType()
	 * @generated
	 */
	int KAFKA_COMPRESSION_TYPE = 14;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol <em>Kafka Security Protocol</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaSecurityProtocol()
	 * @generated
	 */
	int KAFKA_SECURITY_PROTOCOL = 15;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.protocols.SASLMechanism <em>SASL Mechanism</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.protocols.SASLMechanism
	 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getSASLMechanism()
	 * @generated
	 */
	int SASL_MECHANISM = 16;


	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration <em>HTTP Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>HTTP Configuration</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration
	 * @generated
	 */
	EClass getHTTPConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getUrl <em>Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Url</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration#getUrl()
	 * @see #getHTTPConfiguration()
	 * @generated
	 */
	EAttribute getHTTPConfiguration_Url();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getMethod <em>Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Method</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration#getMethod()
	 * @see #getHTTPConfiguration()
	 * @generated
	 */
	EAttribute getHTTPConfiguration_Method();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getHeaders <em>Headers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Headers</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration#getHeaders()
	 * @see #getHTTPConfiguration()
	 * @generated
	 */
	EReference getHTTPConfiguration_Headers();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#isFollowRedirects <em>Follow Redirects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Follow Redirects</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration#isFollowRedirects()
	 * @see #getHTTPConfiguration()
	 * @generated
	 */
	EAttribute getHTTPConfiguration_FollowRedirects();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getContentType <em>Content Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Content Type</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration#getContentType()
	 * @see #getHTTPConfiguration()
	 * @generated
	 */
	EAttribute getHTTPConfiguration_ContentType();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getSecurity <em>Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration#getSecurity()
	 * @see #getHTTPConfiguration()
	 * @generated
	 */
	EReference getHTTPConfiguration_Security();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration <em>MQTT Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>MQTT Configuration</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration
	 * @generated
	 */
	EClass getMQTTConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getBroker <em>Broker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Broker</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#getBroker()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_Broker();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#getPort()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_Port();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getTopic <em>Topic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Topic</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#getTopic()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_Topic();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getQos <em>Qos</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Qos</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#getQos()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_Qos();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#isRetain <em>Retain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Retain</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#isRetain()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_Retain();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getClientId <em>Client Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Client Id</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#getClientId()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_ClientId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#isCleanSession <em>Clean Session</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Clean Session</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#isCleanSession()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_CleanSession();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getKeepAlive <em>Keep Alive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keep Alive</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#getKeepAlive()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EAttribute getMQTTConfiguration_KeepAlive();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getSecurity <em>Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration#getSecurity()
	 * @see #getMQTTConfiguration()
	 * @generated
	 */
	EReference getMQTTConfiguration_Security();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration <em>Web Socket Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Web Socket Configuration</em>'.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration
	 * @generated
	 */
	EClass getWebSocketConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getUrl <em>Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Url</em>'.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getUrl()
	 * @see #getWebSocketConfiguration()
	 * @generated
	 */
	EAttribute getWebSocketConfiguration_Url();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSubprotocol <em>Subprotocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Subprotocol</em>'.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSubprotocol()
	 * @see #getWebSocketConfiguration()
	 * @generated
	 */
	EAttribute getWebSocketConfiguration_Subprotocol();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getPingInterval <em>Ping Interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ping Interval</em>'.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getPingInterval()
	 * @see #getWebSocketConfiguration()
	 * @generated
	 */
	EAttribute getWebSocketConfiguration_PingInterval();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getMaxFrameSize <em>Max Frame Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Frame Size</em>'.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getMaxFrameSize()
	 * @see #getWebSocketConfiguration()
	 * @generated
	 */
	EAttribute getWebSocketConfiguration_MaxFrameSize();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getHeaders <em>Headers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Headers</em>'.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getHeaders()
	 * @see #getWebSocketConfiguration()
	 * @generated
	 */
	EReference getWebSocketConfiguration_Headers();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSecurity <em>Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSecurity()
	 * @see #getWebSocketConfiguration()
	 * @generated
	 */
	EReference getWebSocketConfiguration_Security();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration <em>Kafka Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Kafka Configuration</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration
	 * @generated
	 */
	EClass getKafkaConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getBootstrapServers <em>Bootstrap Servers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bootstrap Servers</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getBootstrapServers()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EAttribute getKafkaConfiguration_BootstrapServers();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getTopic <em>Topic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Topic</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getTopic()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EAttribute getKafkaConfiguration_Topic();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getPartition <em>Partition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Partition</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getPartition()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EAttribute getKafkaConfiguration_Partition();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getKey()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EAttribute getKafkaConfiguration_Key();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getCompressionType <em>Compression Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Compression Type</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getCompressionType()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EAttribute getKafkaConfiguration_CompressionType();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getAcks <em>Acks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Acks</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getAcks()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EAttribute getKafkaConfiguration_Acks();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Properties</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getProperties()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EReference getKafkaConfiguration_Properties();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getSecurity <em>Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration#getSecurity()
	 * @see #getKafkaConfiguration()
	 * @generated
	 */
	EReference getKafkaConfiguration_Security();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration <em>AMQP Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>AMQP Configuration</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration
	 * @generated
	 */
	EClass getAMQPConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#getHost()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_Host();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#getPort()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_Port();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getVirtualHost <em>Virtual Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Virtual Host</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#getVirtualHost()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_VirtualHost();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getExchange <em>Exchange</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Exchange</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#getExchange()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_Exchange();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getRoutingKey <em>Routing Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Routing Key</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#getRoutingKey()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_RoutingKey();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getQueue <em>Queue</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Queue</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#getQueue()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_Queue();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#isDurable <em>Durable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Durable</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#isDurable()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_Durable();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#isAutoDelete <em>Auto Delete</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Auto Delete</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#isAutoDelete()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EAttribute getAMQPConfiguration_AutoDelete();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getSecurity <em>Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration#getSecurity()
	 * @see #getAMQPConfiguration()
	 * @generated
	 */
	EReference getAMQPConfiguration_Security();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.Security <em>Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security
	 * @generated
	 */
	EClass getSecurity();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#getUsername <em>Username</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Username</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#getUsername()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_Username();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#getPassword <em>Password</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Password</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#getPassword()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_Password();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#getKeystorePath <em>Keystore Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keystore Path</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#getKeystorePath()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_KeystorePath();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#getKeyPath <em>Key Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key Path</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#getKeyPath()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_KeyPath();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#getKeystorePassword <em>Keystore Password</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keystore Password</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#getKeystorePassword()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_KeystorePassword();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#getTruststorePath <em>Truststore Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Truststore Path</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#getTruststorePath()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_TruststorePath();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#getTruststorePassword <em>Truststore Password</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Truststore Password</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#getTruststorePassword()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_TruststorePassword();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.Security#isUseSSL <em>Use SSL</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Use SSL</em>'.
	 * @see org.gecko.emf.ngsi.protocols.Security#isUseSSL()
	 * @see #getSecurity()
	 * @generated
	 */
	EAttribute getSecurity_UseSSL();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity <em>HTTP Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>HTTP Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPSecurity
	 * @generated
	 */
	EClass getHTTPSecurity();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getAuthType <em>Auth Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Auth Type</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPSecurity#getAuthType()
	 * @see #getHTTPSecurity()
	 * @generated
	 */
	EAttribute getHTTPSecurity_AuthType();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getBearerToken <em>Bearer Token</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bearer Token</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPSecurity#getBearerToken()
	 * @see #getHTTPSecurity()
	 * @generated
	 */
	EAttribute getHTTPSecurity_BearerToken();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKey <em>Api Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Api Key</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKey()
	 * @see #getHTTPSecurity()
	 * @generated
	 */
	EAttribute getHTTPSecurity_ApiKey();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKeyHeader <em>Api Key Header</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Api Key Header</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKeyHeader()
	 * @see #getHTTPSecurity()
	 * @generated
	 */
	EAttribute getHTTPSecurity_ApiKeyHeader();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#isVerifyHostname <em>Verify Hostname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Verify Hostname</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPSecurity#isVerifyHostname()
	 * @see #getHTTPSecurity()
	 * @generated
	 */
	EAttribute getHTTPSecurity_VerifyHostname();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity <em>MQTT Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>MQTT Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTSecurity
	 * @generated
	 */
	EClass getMQTTSecurity();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#getClientCertPath <em>Client Cert Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Client Cert Path</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTSecurity#getClientCertPath()
	 * @see #getMQTTSecurity()
	 * @generated
	 */
	EAttribute getMQTTSecurity_ClientCertPath();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#getTlsVersion <em>Tls Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tls Version</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTSecurity#getTlsVersion()
	 * @see #getMQTTSecurity()
	 * @generated
	 */
	EAttribute getMQTTSecurity_TlsVersion();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity#isInsecureSkipVerify <em>Insecure Skip Verify</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Insecure Skip Verify</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTSecurity#isInsecureSkipVerify()
	 * @see #getMQTTSecurity()
	 * @generated
	 */
	EAttribute getMQTTSecurity_InsecureSkipVerify();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity <em>Kafka Security</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Kafka Security</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurity
	 * @generated
	 */
	EClass getKafkaSecurity();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSecurityProtocol <em>Security Protocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Security Protocol</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurity#getSecurityProtocol()
	 * @see #getKafkaSecurity()
	 * @generated
	 */
	EAttribute getKafkaSecurity_SecurityProtocol();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslMechanism <em>Sasl Mechanism</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sasl Mechanism</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslMechanism()
	 * @see #getKafkaSecurity()
	 * @generated
	 */
	EAttribute getKafkaSecurity_SaslMechanism();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslJaasConfig <em>Sasl Jaas Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sasl Jaas Config</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslJaasConfig()
	 * @see #getKafkaSecurity()
	 * @generated
	 */
	EAttribute getKafkaSecurity_SaslJaasConfig();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.HTTPHeader <em>HTTP Header</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>HTTP Header</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPHeader
	 * @generated
	 */
	EClass getHTTPHeader();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPHeader#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPHeader#getName()
	 * @see #getHTTPHeader()
	 * @generated
	 */
	EAttribute getHTTPHeader_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.HTTPHeader#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPHeader#getValue()
	 * @see #getHTTPHeader()
	 * @generated
	 */
	EAttribute getHTTPHeader_Value();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.protocols.KafkaProperty <em>Kafka Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Kafka Property</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaProperty
	 * @generated
	 */
	EClass getKafkaProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaProperty#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaProperty#getKey()
	 * @see #getKafkaProperty()
	 * @generated
	 */
	EAttribute getKafkaProperty_Key();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.protocols.KafkaProperty#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaProperty#getValue()
	 * @see #getKafkaProperty()
	 * @generated
	 */
	EAttribute getKafkaProperty_Value();

	/**
	 * Returns the meta object for enum '{@link org.gecko.emf.ngsi.protocols.HTTPMethod <em>HTTP Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>HTTP Method</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPMethod
	 * @generated
	 */
	EEnum getHTTPMethod();

	/**
	 * Returns the meta object for enum '{@link org.gecko.emf.ngsi.protocols.HTTPAuthType <em>HTTP Auth Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>HTTP Auth Type</em>'.
	 * @see org.gecko.emf.ngsi.protocols.HTTPAuthType
	 * @generated
	 */
	EEnum getHTTPAuthType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.emf.ngsi.protocols.MQTTQoS <em>MQTT Qo S</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>MQTT Qo S</em>'.
	 * @see org.gecko.emf.ngsi.protocols.MQTTQoS
	 * @generated
	 */
	EEnum getMQTTQoS();

	/**
	 * Returns the meta object for enum '{@link org.gecko.emf.ngsi.protocols.KafkaCompressionType <em>Kafka Compression Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Kafka Compression Type</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaCompressionType
	 * @generated
	 */
	EEnum getKafkaCompressionType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol <em>Kafka Security Protocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Kafka Security Protocol</em>'.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol
	 * @generated
	 */
	EEnum getKafkaSecurityProtocol();

	/**
	 * Returns the meta object for enum '{@link org.gecko.emf.ngsi.protocols.SASLMechanism <em>SASL Mechanism</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>SASL Mechanism</em>'.
	 * @see org.gecko.emf.ngsi.protocols.SASLMechanism
	 * @generated
	 */
	EEnum getSASLMechanism();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	NGSIProtocolsFactory getNGSIProtocolsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl <em>HTTP Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPConfiguration()
		 * @generated
		 */
		EClass HTTP_CONFIGURATION = eINSTANCE.getHTTPConfiguration();

		/**
		 * The meta object literal for the '<em><b>Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_CONFIGURATION__URL = eINSTANCE.getHTTPConfiguration_Url();

		/**
		 * The meta object literal for the '<em><b>Method</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_CONFIGURATION__METHOD = eINSTANCE.getHTTPConfiguration_Method();

		/**
		 * The meta object literal for the '<em><b>Headers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HTTP_CONFIGURATION__HEADERS = eINSTANCE.getHTTPConfiguration_Headers();

		/**
		 * The meta object literal for the '<em><b>Follow Redirects</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_CONFIGURATION__FOLLOW_REDIRECTS = eINSTANCE.getHTTPConfiguration_FollowRedirects();

		/**
		 * The meta object literal for the '<em><b>Content Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_CONFIGURATION__CONTENT_TYPE = eINSTANCE.getHTTPConfiguration_ContentType();

		/**
		 * The meta object literal for the '<em><b>Security</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HTTP_CONFIGURATION__SECURITY = eINSTANCE.getHTTPConfiguration_Security();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl <em>MQTT Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getMQTTConfiguration()
		 * @generated
		 */
		EClass MQTT_CONFIGURATION = eINSTANCE.getMQTTConfiguration();

		/**
		 * The meta object literal for the '<em><b>Broker</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__BROKER = eINSTANCE.getMQTTConfiguration_Broker();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__PORT = eINSTANCE.getMQTTConfiguration_Port();

		/**
		 * The meta object literal for the '<em><b>Topic</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__TOPIC = eINSTANCE.getMQTTConfiguration_Topic();

		/**
		 * The meta object literal for the '<em><b>Qos</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__QOS = eINSTANCE.getMQTTConfiguration_Qos();

		/**
		 * The meta object literal for the '<em><b>Retain</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__RETAIN = eINSTANCE.getMQTTConfiguration_Retain();

		/**
		 * The meta object literal for the '<em><b>Client Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__CLIENT_ID = eINSTANCE.getMQTTConfiguration_ClientId();

		/**
		 * The meta object literal for the '<em><b>Clean Session</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__CLEAN_SESSION = eINSTANCE.getMQTTConfiguration_CleanSession();

		/**
		 * The meta object literal for the '<em><b>Keep Alive</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_CONFIGURATION__KEEP_ALIVE = eINSTANCE.getMQTTConfiguration_KeepAlive();

		/**
		 * The meta object literal for the '<em><b>Security</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MQTT_CONFIGURATION__SECURITY = eINSTANCE.getMQTTConfiguration_Security();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl <em>Web Socket Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getWebSocketConfiguration()
		 * @generated
		 */
		EClass WEB_SOCKET_CONFIGURATION = eINSTANCE.getWebSocketConfiguration();

		/**
		 * The meta object literal for the '<em><b>Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute WEB_SOCKET_CONFIGURATION__URL = eINSTANCE.getWebSocketConfiguration_Url();

		/**
		 * The meta object literal for the '<em><b>Subprotocol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute WEB_SOCKET_CONFIGURATION__SUBPROTOCOL = eINSTANCE.getWebSocketConfiguration_Subprotocol();

		/**
		 * The meta object literal for the '<em><b>Ping Interval</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute WEB_SOCKET_CONFIGURATION__PING_INTERVAL = eINSTANCE.getWebSocketConfiguration_PingInterval();

		/**
		 * The meta object literal for the '<em><b>Max Frame Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE = eINSTANCE.getWebSocketConfiguration_MaxFrameSize();

		/**
		 * The meta object literal for the '<em><b>Headers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WEB_SOCKET_CONFIGURATION__HEADERS = eINSTANCE.getWebSocketConfiguration_Headers();

		/**
		 * The meta object literal for the '<em><b>Security</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WEB_SOCKET_CONFIGURATION__SECURITY = eINSTANCE.getWebSocketConfiguration_Security();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl <em>Kafka Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaConfiguration()
		 * @generated
		 */
		EClass KAFKA_CONFIGURATION = eINSTANCE.getKafkaConfiguration();

		/**
		 * The meta object literal for the '<em><b>Bootstrap Servers</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS = eINSTANCE.getKafkaConfiguration_BootstrapServers();

		/**
		 * The meta object literal for the '<em><b>Topic</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_CONFIGURATION__TOPIC = eINSTANCE.getKafkaConfiguration_Topic();

		/**
		 * The meta object literal for the '<em><b>Partition</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_CONFIGURATION__PARTITION = eINSTANCE.getKafkaConfiguration_Partition();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_CONFIGURATION__KEY = eINSTANCE.getKafkaConfiguration_Key();

		/**
		 * The meta object literal for the '<em><b>Compression Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_CONFIGURATION__COMPRESSION_TYPE = eINSTANCE.getKafkaConfiguration_CompressionType();

		/**
		 * The meta object literal for the '<em><b>Acks</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_CONFIGURATION__ACKS = eINSTANCE.getKafkaConfiguration_Acks();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference KAFKA_CONFIGURATION__PROPERTIES = eINSTANCE.getKafkaConfiguration_Properties();

		/**
		 * The meta object literal for the '<em><b>Security</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference KAFKA_CONFIGURATION__SECURITY = eINSTANCE.getKafkaConfiguration_Security();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl <em>AMQP Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getAMQPConfiguration()
		 * @generated
		 */
		EClass AMQP_CONFIGURATION = eINSTANCE.getAMQPConfiguration();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__HOST = eINSTANCE.getAMQPConfiguration_Host();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__PORT = eINSTANCE.getAMQPConfiguration_Port();

		/**
		 * The meta object literal for the '<em><b>Virtual Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__VIRTUAL_HOST = eINSTANCE.getAMQPConfiguration_VirtualHost();

		/**
		 * The meta object literal for the '<em><b>Exchange</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__EXCHANGE = eINSTANCE.getAMQPConfiguration_Exchange();

		/**
		 * The meta object literal for the '<em><b>Routing Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__ROUTING_KEY = eINSTANCE.getAMQPConfiguration_RoutingKey();

		/**
		 * The meta object literal for the '<em><b>Queue</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__QUEUE = eINSTANCE.getAMQPConfiguration_Queue();

		/**
		 * The meta object literal for the '<em><b>Durable</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__DURABLE = eINSTANCE.getAMQPConfiguration_Durable();

		/**
		 * The meta object literal for the '<em><b>Auto Delete</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AMQP_CONFIGURATION__AUTO_DELETE = eINSTANCE.getAMQPConfiguration_AutoDelete();

		/**
		 * The meta object literal for the '<em><b>Security</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AMQP_CONFIGURATION__SECURITY = eINSTANCE.getAMQPConfiguration_Security();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl <em>Security</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.SecurityImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getSecurity()
		 * @generated
		 */
		EClass SECURITY = eINSTANCE.getSecurity();

		/**
		 * The meta object literal for the '<em><b>Username</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__USERNAME = eINSTANCE.getSecurity_Username();

		/**
		 * The meta object literal for the '<em><b>Password</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__PASSWORD = eINSTANCE.getSecurity_Password();

		/**
		 * The meta object literal for the '<em><b>Keystore Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__KEYSTORE_PATH = eINSTANCE.getSecurity_KeystorePath();

		/**
		 * The meta object literal for the '<em><b>Key Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__KEY_PATH = eINSTANCE.getSecurity_KeyPath();

		/**
		 * The meta object literal for the '<em><b>Keystore Password</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__KEYSTORE_PASSWORD = eINSTANCE.getSecurity_KeystorePassword();

		/**
		 * The meta object literal for the '<em><b>Truststore Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__TRUSTSTORE_PATH = eINSTANCE.getSecurity_TruststorePath();

		/**
		 * The meta object literal for the '<em><b>Truststore Password</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__TRUSTSTORE_PASSWORD = eINSTANCE.getSecurity_TruststorePassword();

		/**
		 * The meta object literal for the '<em><b>Use SSL</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECURITY__USE_SSL = eINSTANCE.getSecurity_UseSSL();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl <em>HTTP Security</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPSecurity()
		 * @generated
		 */
		EClass HTTP_SECURITY = eINSTANCE.getHTTPSecurity();

		/**
		 * The meta object literal for the '<em><b>Auth Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_SECURITY__AUTH_TYPE = eINSTANCE.getHTTPSecurity_AuthType();

		/**
		 * The meta object literal for the '<em><b>Bearer Token</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_SECURITY__BEARER_TOKEN = eINSTANCE.getHTTPSecurity_BearerToken();

		/**
		 * The meta object literal for the '<em><b>Api Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_SECURITY__API_KEY = eINSTANCE.getHTTPSecurity_ApiKey();

		/**
		 * The meta object literal for the '<em><b>Api Key Header</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_SECURITY__API_KEY_HEADER = eINSTANCE.getHTTPSecurity_ApiKeyHeader();

		/**
		 * The meta object literal for the '<em><b>Verify Hostname</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_SECURITY__VERIFY_HOSTNAME = eINSTANCE.getHTTPSecurity_VerifyHostname();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.MQTTSecurityImpl <em>MQTT Security</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.MQTTSecurityImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getMQTTSecurity()
		 * @generated
		 */
		EClass MQTT_SECURITY = eINSTANCE.getMQTTSecurity();

		/**
		 * The meta object literal for the '<em><b>Client Cert Path</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_SECURITY__CLIENT_CERT_PATH = eINSTANCE.getMQTTSecurity_ClientCertPath();

		/**
		 * The meta object literal for the '<em><b>Tls Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_SECURITY__TLS_VERSION = eINSTANCE.getMQTTSecurity_TlsVersion();

		/**
		 * The meta object literal for the '<em><b>Insecure Skip Verify</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MQTT_SECURITY__INSECURE_SKIP_VERIFY = eINSTANCE.getMQTTSecurity_InsecureSkipVerify();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.KafkaSecurityImpl <em>Kafka Security</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.KafkaSecurityImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaSecurity()
		 * @generated
		 */
		EClass KAFKA_SECURITY = eINSTANCE.getKafkaSecurity();

		/**
		 * The meta object literal for the '<em><b>Security Protocol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_SECURITY__SECURITY_PROTOCOL = eINSTANCE.getKafkaSecurity_SecurityProtocol();

		/**
		 * The meta object literal for the '<em><b>Sasl Mechanism</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_SECURITY__SASL_MECHANISM = eINSTANCE.getKafkaSecurity_SaslMechanism();

		/**
		 * The meta object literal for the '<em><b>Sasl Jaas Config</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_SECURITY__SASL_JAAS_CONFIG = eINSTANCE.getKafkaSecurity_SaslJaasConfig();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.HTTPHeaderImpl <em>HTTP Header</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.HTTPHeaderImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPHeader()
		 * @generated
		 */
		EClass HTTP_HEADER = eINSTANCE.getHTTPHeader();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_HEADER__NAME = eINSTANCE.getHTTPHeader_Name();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HTTP_HEADER__VALUE = eINSTANCE.getHTTPHeader_Value();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.impl.KafkaPropertyImpl <em>Kafka Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.impl.KafkaPropertyImpl
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaProperty()
		 * @generated
		 */
		EClass KAFKA_PROPERTY = eINSTANCE.getKafkaProperty();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_PROPERTY__KEY = eINSTANCE.getKafkaProperty_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute KAFKA_PROPERTY__VALUE = eINSTANCE.getKafkaProperty_Value();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.HTTPMethod <em>HTTP Method</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.HTTPMethod
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPMethod()
		 * @generated
		 */
		EEnum HTTP_METHOD = eINSTANCE.getHTTPMethod();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.HTTPAuthType <em>HTTP Auth Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.HTTPAuthType
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getHTTPAuthType()
		 * @generated
		 */
		EEnum HTTP_AUTH_TYPE = eINSTANCE.getHTTPAuthType();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.MQTTQoS <em>MQTT Qo S</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.MQTTQoS
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getMQTTQoS()
		 * @generated
		 */
		EEnum MQTT_QO_S = eINSTANCE.getMQTTQoS();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.KafkaCompressionType <em>Kafka Compression Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.KafkaCompressionType
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaCompressionType()
		 * @generated
		 */
		EEnum KAFKA_COMPRESSION_TYPE = eINSTANCE.getKafkaCompressionType();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol <em>Kafka Security Protocol</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getKafkaSecurityProtocol()
		 * @generated
		 */
		EEnum KAFKA_SECURITY_PROTOCOL = eINSTANCE.getKafkaSecurityProtocol();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.protocols.SASLMechanism <em>SASL Mechanism</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.protocols.SASLMechanism
		 * @see org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl#getSASLMechanism()
		 * @generated
		 */
		EEnum SASL_MECHANISM = eINSTANCE.getSASLMechanism();

	}

} //NGSIProtocolsPackage
