/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>SASL Mechanism</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * SASL authentication mechanisms.
 * <!-- end-model-doc -->
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSASLMechanism()
 * @model
 * @generated
 */
@ProviderType
public enum SASLMechanism implements Enumerator {
	/**
	 * The '<em><b>PLAIN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PLAIN_VALUE
	 * @generated
	 * @ordered
	 */
	PLAIN(0, "PLAIN", "PLAIN"),

	/**
	 * The '<em><b>SCRAM SHA 256</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCRAM_SHA_256_VALUE
	 * @generated
	 * @ordered
	 */
	SCRAM_SHA_256(1, "SCRAM_SHA_256", "SCRAM-SHA-256"),

	/**
	 * The '<em><b>SCRAM SHA 512</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCRAM_SHA_512_VALUE
	 * @generated
	 * @ordered
	 */
	SCRAM_SHA_512(2, "SCRAM_SHA_512", "SCRAM-SHA-512"),

	/**
	 * The '<em><b>GSSAPI</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GSSAPI_VALUE
	 * @generated
	 * @ordered
	 */
	GSSAPI(3, "GSSAPI", "GSSAPI"),

	/**
	 * The '<em><b>OAUTHBEARER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OAUTHBEARER_VALUE
	 * @generated
	 * @ordered
	 */
	OAUTHBEARER(4, "OAUTHBEARER", "OAUTHBEARER");

	/**
	 * The '<em><b>PLAIN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PLAIN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PLAIN_VALUE = 0;

	/**
	 * The '<em><b>SCRAM SHA 256</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCRAM_SHA_256
	 * @model literal="SCRAM-SHA-256"
	 * @generated
	 * @ordered
	 */
	public static final int SCRAM_SHA_256_VALUE = 1;

	/**
	 * The '<em><b>SCRAM SHA 512</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCRAM_SHA_512
	 * @model literal="SCRAM-SHA-512"
	 * @generated
	 * @ordered
	 */
	public static final int SCRAM_SHA_512_VALUE = 2;

	/**
	 * The '<em><b>GSSAPI</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GSSAPI
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GSSAPI_VALUE = 3;

	/**
	 * The '<em><b>OAUTHBEARER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OAUTHBEARER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OAUTHBEARER_VALUE = 4;

	/**
	 * An array of all the '<em><b>SASL Mechanism</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final SASLMechanism[] VALUES_ARRAY =
		new SASLMechanism[] {
			PLAIN,
			SCRAM_SHA_256,
			SCRAM_SHA_512,
			GSSAPI,
			OAUTHBEARER,
		};

	/**
	 * A public read-only list of all the '<em><b>SASL Mechanism</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<SASLMechanism> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>SASL Mechanism</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static SASLMechanism get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			SASLMechanism result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>SASL Mechanism</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static SASLMechanism getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			SASLMechanism result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>SASL Mechanism</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static SASLMechanism get(int value) {
		switch (value) {
			case PLAIN_VALUE: return PLAIN;
			case SCRAM_SHA_256_VALUE: return SCRAM_SHA_256;
			case SCRAM_SHA_512_VALUE: return SCRAM_SHA_512;
			case GSSAPI_VALUE: return GSSAPI;
			case OAUTHBEARER_VALUE: return OAUTHBEARER;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private SASLMechanism(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //SASLMechanism
