/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Security</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Abstract base class for security configurations.
 * 
 * Provides common security attributes that can be used across different protocols including authentication credentials, SSL/TLS configuration, and certificate management.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#getUsername <em>Username</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#getPassword <em>Password</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#getKeystorePath <em>Keystore Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#getKeyPath <em>Key Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#getKeystorePassword <em>Keystore Password</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#getTruststorePath <em>Truststore Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#getTruststorePassword <em>Truststore Password</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.Security#isUseSSL <em>Use SSL</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity()
 * @model abstract="true"
 * @generated
 */
@ProviderType
public interface Security extends EObject {
	/**
	 * Returns the value of the '<em><b>Username</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Username for authentication.
	 * 
	 * Used for basic authentication, SASL, or other username-based authentication mechanisms.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Username</em>' attribute.
	 * @see #setUsername(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_Username()
	 * @model
	 * @generated
	 */
	String getUsername();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#getUsername <em>Username</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Username</em>' attribute.
	 * @see #getUsername()
	 * @generated
	 */
	void setUsername(String value);

	/**
	 * Returns the value of the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Password for authentication.
	 * 
	 * Used in conjunction with username for authentication. Should be stored securely.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Password</em>' attribute.
	 * @see #setPassword(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_Password()
	 * @model
	 * @generated
	 */
	String getPassword();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#getPassword <em>Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Password</em>' attribute.
	 * @see #getPassword()
	 * @generated
	 */
	void setPassword(String value);

	/**
	 * Returns the value of the '<em><b>Keystore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Path to the keystore file.
	 * 
	 * Contains the client's private key and certificate for mutual TLS authentication.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Keystore Path</em>' attribute.
	 * @see #setKeystorePath(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_KeystorePath()
	 * @model
	 * @generated
	 */
	String getKeystorePath();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#getKeystorePath <em>Keystore Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keystore Path</em>' attribute.
	 * @see #getKeystorePath()
	 * @generated
	 */
	void setKeystorePath(String value);

	/**
	 * Returns the value of the '<em><b>Key Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Path to the private key file.
	 * 
	 * Alternative to keystore for PEM-format private keys.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Key Path</em>' attribute.
	 * @see #setKeyPath(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_KeyPath()
	 * @model
	 * @generated
	 */
	String getKeyPath();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#getKeyPath <em>Key Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Key Path</em>' attribute.
	 * @see #getKeyPath()
	 * @generated
	 */
	void setKeyPath(String value);

	/**
	 * Returns the value of the '<em><b>Keystore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Password for the keystore.
	 * 
	 * Required if the keystore is password-protected. Should be stored securely.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Keystore Password</em>' attribute.
	 * @see #setKeystorePassword(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_KeystorePassword()
	 * @model
	 * @generated
	 */
	String getKeystorePassword();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#getKeystorePassword <em>Keystore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keystore Password</em>' attribute.
	 * @see #getKeystorePassword()
	 * @generated
	 */
	void setKeystorePassword(String value);

	/**
	 * Returns the value of the '<em><b>Truststore Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Path to the truststore file.
	 * 
	 * Contains trusted CA certificates for server certificate validation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Truststore Path</em>' attribute.
	 * @see #setTruststorePath(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_TruststorePath()
	 * @model
	 * @generated
	 */
	String getTruststorePath();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#getTruststorePath <em>Truststore Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Truststore Path</em>' attribute.
	 * @see #getTruststorePath()
	 * @generated
	 */
	void setTruststorePath(String value);

	/**
	 * Returns the value of the '<em><b>Truststore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Password for the truststore.
	 * 
	 * Required if the truststore is password-protected. Should be stored securely.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Truststore Password</em>' attribute.
	 * @see #setTruststorePassword(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_TruststorePassword()
	 * @model
	 * @generated
	 */
	String getTruststorePassword();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#getTruststorePassword <em>Truststore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Truststore Password</em>' attribute.
	 * @see #getTruststorePassword()
	 * @generated
	 */
	void setTruststorePassword(String value);

	/**
	 * Returns the value of the '<em><b>Use SSL</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to use SSL/TLS encryption.
	 * 
	 * Enables encrypted communication between client and server.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Use SSL</em>' attribute.
	 * @see #setUseSSL(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getSecurity_UseSSL()
	 * @model default="false"
	 * @generated
	 */
	boolean isUseSSL();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.Security#isUseSSL <em>Use SSL</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Use SSL</em>' attribute.
	 * @see #isUseSSL()
	 * @generated
	 */
	void setUseSSL(boolean value);

} // Security
