/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.eclipse.emf.common.util.EList;

import org.gecko.emf.ngsi.ProtocolConfiguration;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Web Socket Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * WebSocket protocol configuration for NGSI-LD notifications.
 * 
 * Provides WebSocket-based notification delivery for real-time applications. Supports sub-protocols and connection management.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getUrl <em>Url</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSubprotocol <em>Subprotocol</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getPingInterval <em>Ping Interval</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getMaxFrameSize <em>Max Frame Size</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getHeaders <em>Headers</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getWebSocketConfiguration()
 * @model
 * @generated
 */
@ProviderType
public interface WebSocketConfiguration extends ProtocolConfiguration {
	/**
	 * Returns the value of the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * WebSocket URL for notifications.
	 * 
	 * Must be a valid WebSocket URL (ws:// or wss://) that can receive notification messages.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Url</em>' attribute.
	 * @see #setUrl(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getWebSocketConfiguration_Url()
	 * @model required="true"
	 * @generated
	 */
	String getUrl();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getUrl <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Url</em>' attribute.
	 * @see #getUrl()
	 * @generated
	 */
	void setUrl(String value);

	/**
	 * Returns the value of the '<em><b>Subprotocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * WebSocket sub-protocol to use.
	 * 
	 * Optional sub-protocol for specialized communication patterns.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Subprotocol</em>' attribute.
	 * @see #setSubprotocol(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getWebSocketConfiguration_Subprotocol()
	 * @model
	 * @generated
	 */
	String getSubprotocol();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSubprotocol <em>Subprotocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Subprotocol</em>' attribute.
	 * @see #getSubprotocol()
	 * @generated
	 */
	void setSubprotocol(String value);

	/**
	 * Returns the value of the '<em><b>Ping Interval</b></em>' attribute.
	 * The default value is <code>"30000"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Ping interval in milliseconds.
	 * 
	 * Frequency of ping frames to keep the connection alive.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Ping Interval</em>' attribute.
	 * @see #setPingInterval(int)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getWebSocketConfiguration_PingInterval()
	 * @model default="30000"
	 * @generated
	 */
	int getPingInterval();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getPingInterval <em>Ping Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ping Interval</em>' attribute.
	 * @see #getPingInterval()
	 * @generated
	 */
	void setPingInterval(int value);

	/**
	 * Returns the value of the '<em><b>Max Frame Size</b></em>' attribute.
	 * The default value is <code>"65536"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Maximum frame size in bytes.
	 * 
	 * Maximum size of WebSocket frames for message transmission.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Max Frame Size</em>' attribute.
	 * @see #setMaxFrameSize(int)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getWebSocketConfiguration_MaxFrameSize()
	 * @model default="65536"
	 * @generated
	 */
	int getMaxFrameSize();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getMaxFrameSize <em>Max Frame Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Max Frame Size</em>' attribute.
	 * @see #getMaxFrameSize()
	 * @generated
	 */
	void setMaxFrameSize(int value);

	/**
	 * Returns the value of the '<em><b>Headers</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.protocols.HTTPHeader}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Custom headers for WebSocket handshake.
	 * 
	 * HTTP headers to include in the WebSocket upgrade request.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Headers</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getWebSocketConfiguration_Headers()
	 * @model containment="true"
	 * @generated
	 */
	EList<HTTPHeader> getHeaders();

	/**
	 * Returns the value of the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Security configuration for WebSocket notifications.
	 * 
	 * Supports authentication and TLS encryption.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Security</em>' containment reference.
	 * @see #setSecurity(Security)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getWebSocketConfiguration_Security()
	 * @model containment="true"
	 * @generated
	 */
	Security getSecurity();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration#getSecurity <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Security</em>' containment reference.
	 * @see #getSecurity()
	 * @generated
	 */
	void setSecurity(Security value);

} // WebSocketConfiguration
