/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.configuration;

import java.util.HashMap;
import java.util.Map;

import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;

import org.gecko.emf.osgi.configurator.EPackageConfigurator;

import org.gecko.emf.osgi.constants.EMFNamespaces;

/**
 * <!-- begin-user-doc -->
 * The <b>EPackageConfiguration</b> and <b>ResourceFactoryConfigurator</b> for the model.
 * The package will be registered into a OSGi base model registry.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * NGSI-LD Protocol Extension Model
 * 
 * This model provides concrete implementations of protocol configurations for NGSI-LD notifications. It extends the abstract protocol configuration defined in the NGSI-LD wrapper model with specific implementations for HTTP, MQTT, WebSocket, Kafka, and AMQP protocols.
 * 
 * Supports multi-protocol notification delivery with security and reliability features.
 * <!-- end-model-doc -->
 * @see EPackageConfigurator
 * @generated
 */
public class NGSIProtocolsEPackageConfigurator implements EPackageConfigurator {
	
	private NGSIProtocolsPackage ePackage;

	protected NGSIProtocolsEPackageConfigurator(NGSIProtocolsPackage ePackage){
		this.ePackage = ePackage;
	}
	
	/**
	 * (non-Javadoc)
	 * @see org.gecko.emf.osgi.EPackageRegistryConfigurator#configureEPackage(org.eclipse.emf.ecore.EPackage.Registry)
	 * @generated
	 */
	@Override
	public void configureEPackage(org.eclipse.emf.ecore.EPackage.Registry registry) {
		registry.put(NGSIProtocolsPackage.eNS_URI, ePackage);
	}
	
	/**
	 * (non-Javadoc)
	 * @see org.gecko.emf.osgi.EPackageRegistryConfigurator#unconfigureEPackage(org.eclipse.emf.ecore.EPackage.Registry)
	 * @generated
	 */
	@Override
	public void unconfigureEPackage(org.eclipse.emf.ecore.EPackage.Registry registry) {
		registry.remove(NGSIProtocolsPackage.eNS_URI);
	}
	
	/**
	 * A method providing the Properties the services around this Model should be registered with.
	 * @generated
	 */
	public Map<String, Object> getServiceProperties() {
		Map<String, Object> properties = new HashMap<String, Object>();
		properties.put(EMFNamespaces.EMF_MODEL_NAME, NGSIProtocolsPackage.eNAME);
		properties.put(EMFNamespaces.EMF_MODEL_NSURI, NGSIProtocolsPackage.eNS_URI);
		properties.put(EMFNamespaces.EMF_MODEL_FILE_EXT, "ngsiprotocols");
		properties.put(EMFNamespaces.EMF_MODEL_VERSION, "1.0");
		return properties;
	}
}