/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl;

import org.gecko.emf.ngsi.protocols.AMQPConfiguration;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;
import org.gecko.emf.ngsi.protocols.Security;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>AMQP Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#getHost <em>Host</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#getPort <em>Port</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#getVirtualHost <em>Virtual Host</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#getExchange <em>Exchange</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#getRoutingKey <em>Routing Key</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#getQueue <em>Queue</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#isDurable <em>Durable</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#isAutoDelete <em>Auto Delete</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.AMQPConfigurationImpl#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AMQPConfigurationImpl extends ProtocolConfigurationImpl implements AMQPConfiguration {
	/**
	 * The default value of the '{@link #getHost() <em>Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHost()
	 * @generated
	 * @ordered
	 */
	protected static final String HOST_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHost() <em>Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHost()
	 * @generated
	 * @ordered
	 */
	protected String host = HOST_EDEFAULT;

	/**
	 * The default value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected static final int PORT_EDEFAULT = 5672;

	/**
	 * The cached value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected int port = PORT_EDEFAULT;

	/**
	 * The default value of the '{@link #getVirtualHost() <em>Virtual Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVirtualHost()
	 * @generated
	 * @ordered
	 */
	protected static final String VIRTUAL_HOST_EDEFAULT = "/";

	/**
	 * The cached value of the '{@link #getVirtualHost() <em>Virtual Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVirtualHost()
	 * @generated
	 * @ordered
	 */
	protected String virtualHost = VIRTUAL_HOST_EDEFAULT;

	/**
	 * The default value of the '{@link #getExchange() <em>Exchange</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExchange()
	 * @generated
	 * @ordered
	 */
	protected static final String EXCHANGE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getExchange() <em>Exchange</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExchange()
	 * @generated
	 * @ordered
	 */
	protected String exchange = EXCHANGE_EDEFAULT;

	/**
	 * The default value of the '{@link #getRoutingKey() <em>Routing Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRoutingKey()
	 * @generated
	 * @ordered
	 */
	protected static final String ROUTING_KEY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRoutingKey() <em>Routing Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRoutingKey()
	 * @generated
	 * @ordered
	 */
	protected String routingKey = ROUTING_KEY_EDEFAULT;

	/**
	 * The default value of the '{@link #getQueue() <em>Queue</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueue()
	 * @generated
	 * @ordered
	 */
	protected static final String QUEUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getQueue() <em>Queue</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueue()
	 * @generated
	 * @ordered
	 */
	protected String queue = QUEUE_EDEFAULT;

	/**
	 * The default value of the '{@link #isDurable() <em>Durable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDurable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DURABLE_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isDurable() <em>Durable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDurable()
	 * @generated
	 * @ordered
	 */
	protected boolean durable = DURABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isAutoDelete() <em>Auto Delete</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAutoDelete()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AUTO_DELETE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAutoDelete() <em>Auto Delete</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAutoDelete()
	 * @generated
	 * @ordered
	 */
	protected boolean autoDelete = AUTO_DELETE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSecurity() <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecurity()
	 * @generated
	 * @ordered
	 */
	protected Security security;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AMQPConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.AMQP_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getHost() {
		return host;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHost(String newHost) {
		String oldHost = host;
		host = newHost;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__HOST, oldHost, host));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPort() {
		return port;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPort(int newPort) {
		int oldPort = port;
		port = newPort;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__PORT, oldPort, port));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getVirtualHost() {
		return virtualHost;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVirtualHost(String newVirtualHost) {
		String oldVirtualHost = virtualHost;
		virtualHost = newVirtualHost;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__VIRTUAL_HOST, oldVirtualHost, virtualHost));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getExchange() {
		return exchange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExchange(String newExchange) {
		String oldExchange = exchange;
		exchange = newExchange;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__EXCHANGE, oldExchange, exchange));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRoutingKey() {
		return routingKey;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRoutingKey(String newRoutingKey) {
		String oldRoutingKey = routingKey;
		routingKey = newRoutingKey;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__ROUTING_KEY, oldRoutingKey, routingKey));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getQueue() {
		return queue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setQueue(String newQueue) {
		String oldQueue = queue;
		queue = newQueue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__QUEUE, oldQueue, queue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isDurable() {
		return durable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDurable(boolean newDurable) {
		boolean oldDurable = durable;
		durable = newDurable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__DURABLE, oldDurable, durable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAutoDelete() {
		return autoDelete;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAutoDelete(boolean newAutoDelete) {
		boolean oldAutoDelete = autoDelete;
		autoDelete = newAutoDelete;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__AUTO_DELETE, oldAutoDelete, autoDelete));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Security getSecurity() {
		return security;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSecurity(Security newSecurity, NotificationChain msgs) {
		Security oldSecurity = security;
		security = newSecurity;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY, oldSecurity, newSecurity);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSecurity(Security newSecurity) {
		if (newSecurity != security) {
			NotificationChain msgs = null;
			if (security != null)
				msgs = ((InternalEObject)security).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY, null, msgs);
			if (newSecurity != null)
				msgs = ((InternalEObject)newSecurity).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY, null, msgs);
			msgs = basicSetSecurity(newSecurity, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY, newSecurity, newSecurity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY:
				return basicSetSecurity(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__HOST:
				return getHost();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__PORT:
				return getPort();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__VIRTUAL_HOST:
				return getVirtualHost();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__EXCHANGE:
				return getExchange();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__ROUTING_KEY:
				return getRoutingKey();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__QUEUE:
				return getQueue();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__DURABLE:
				return isDurable();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__AUTO_DELETE:
				return isAutoDelete();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY:
				return getSecurity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__HOST:
				setHost((String)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__PORT:
				setPort((Integer)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__VIRTUAL_HOST:
				setVirtualHost((String)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__EXCHANGE:
				setExchange((String)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__ROUTING_KEY:
				setRoutingKey((String)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__QUEUE:
				setQueue((String)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__DURABLE:
				setDurable((Boolean)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__AUTO_DELETE:
				setAutoDelete((Boolean)newValue);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY:
				setSecurity((Security)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__HOST:
				setHost(HOST_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__PORT:
				setPort(PORT_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__VIRTUAL_HOST:
				setVirtualHost(VIRTUAL_HOST_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__EXCHANGE:
				setExchange(EXCHANGE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__ROUTING_KEY:
				setRoutingKey(ROUTING_KEY_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__QUEUE:
				setQueue(QUEUE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__DURABLE:
				setDurable(DURABLE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__AUTO_DELETE:
				setAutoDelete(AUTO_DELETE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY:
				setSecurity((Security)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__HOST:
				return HOST_EDEFAULT == null ? host != null : !HOST_EDEFAULT.equals(host);
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__PORT:
				return port != PORT_EDEFAULT;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__VIRTUAL_HOST:
				return VIRTUAL_HOST_EDEFAULT == null ? virtualHost != null : !VIRTUAL_HOST_EDEFAULT.equals(virtualHost);
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__EXCHANGE:
				return EXCHANGE_EDEFAULT == null ? exchange != null : !EXCHANGE_EDEFAULT.equals(exchange);
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__ROUTING_KEY:
				return ROUTING_KEY_EDEFAULT == null ? routingKey != null : !ROUTING_KEY_EDEFAULT.equals(routingKey);
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__QUEUE:
				return QUEUE_EDEFAULT == null ? queue != null : !QUEUE_EDEFAULT.equals(queue);
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__DURABLE:
				return durable != DURABLE_EDEFAULT;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__AUTO_DELETE:
				return autoDelete != AUTO_DELETE_EDEFAULT;
			case NGSIProtocolsPackage.AMQP_CONFIGURATION__SECURITY:
				return security != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (host: ");
		result.append(host);
		result.append(", port: ");
		result.append(port);
		result.append(", virtualHost: ");
		result.append(virtualHost);
		result.append(", exchange: ");
		result.append(exchange);
		result.append(", routingKey: ");
		result.append(routingKey);
		result.append(", queue: ");
		result.append(queue);
		result.append(", durable: ");
		result.append(durable);
		result.append(", autoDelete: ");
		result.append(autoDelete);
		result.append(')');
		return result.toString();
	}

} //AMQPConfigurationImpl
