/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl;

import org.gecko.emf.ngsi.protocols.HTTPConfiguration;
import org.gecko.emf.ngsi.protocols.HTTPHeader;
import org.gecko.emf.ngsi.protocols.HTTPMethod;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;
import org.gecko.emf.ngsi.protocols.Security;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>HTTP Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl#getUrl <em>Url</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl#getMethod <em>Method</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl#getHeaders <em>Headers</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl#isFollowRedirects <em>Follow Redirects</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl#getContentType <em>Content Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPConfigurationImpl#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @generated
 */
public class HTTPConfigurationImpl extends ProtocolConfigurationImpl implements HTTPConfiguration {
	/**
	 * The default value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected String url = URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getMethod() <em>Method</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethod()
	 * @generated
	 * @ordered
	 */
	protected static final HTTPMethod METHOD_EDEFAULT = HTTPMethod.POST;

	/**
	 * The cached value of the '{@link #getMethod() <em>Method</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethod()
	 * @generated
	 * @ordered
	 */
	protected HTTPMethod method = METHOD_EDEFAULT;

	/**
	 * The cached value of the '{@link #getHeaders() <em>Headers</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeaders()
	 * @generated
	 * @ordered
	 */
	protected EList<HTTPHeader> headers;

	/**
	 * The default value of the '{@link #isFollowRedirects() <em>Follow Redirects</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFollowRedirects()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FOLLOW_REDIRECTS_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isFollowRedirects() <em>Follow Redirects</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFollowRedirects()
	 * @generated
	 * @ordered
	 */
	protected boolean followRedirects = FOLLOW_REDIRECTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getContentType() <em>Content Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContentType()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTENT_TYPE_EDEFAULT = "application/json";

	/**
	 * The cached value of the '{@link #getContentType() <em>Content Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContentType()
	 * @generated
	 * @ordered
	 */
	protected String contentType = CONTENT_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSecurity() <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecurity()
	 * @generated
	 * @ordered
	 */
	protected Security security;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HTTPConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.HTTP_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUrl() {
		return url;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUrl(String newUrl) {
		String oldUrl = url;
		url = newUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_CONFIGURATION__URL, oldUrl, url));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HTTPMethod getMethod() {
		return method;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMethod(HTTPMethod newMethod) {
		HTTPMethod oldMethod = method;
		method = newMethod == null ? METHOD_EDEFAULT : newMethod;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_CONFIGURATION__METHOD, oldMethod, method));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<HTTPHeader> getHeaders() {
		if (headers == null) {
			headers = new EObjectContainmentEList<HTTPHeader>(HTTPHeader.class, this, NGSIProtocolsPackage.HTTP_CONFIGURATION__HEADERS);
		}
		return headers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFollowRedirects() {
		return followRedirects;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFollowRedirects(boolean newFollowRedirects) {
		boolean oldFollowRedirects = followRedirects;
		followRedirects = newFollowRedirects;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_CONFIGURATION__FOLLOW_REDIRECTS, oldFollowRedirects, followRedirects));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getContentType() {
		return contentType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContentType(String newContentType) {
		String oldContentType = contentType;
		contentType = newContentType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_CONFIGURATION__CONTENT_TYPE, oldContentType, contentType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Security getSecurity() {
		return security;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSecurity(Security newSecurity, NotificationChain msgs) {
		Security oldSecurity = security;
		security = newSecurity;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY, oldSecurity, newSecurity);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSecurity(Security newSecurity) {
		if (newSecurity != security) {
			NotificationChain msgs = null;
			if (security != null)
				msgs = ((InternalEObject)security).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY, null, msgs);
			if (newSecurity != null)
				msgs = ((InternalEObject)newSecurity).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY, null, msgs);
			msgs = basicSetSecurity(newSecurity, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY, newSecurity, newSecurity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__HEADERS:
				return ((InternalEList<?>)getHeaders()).basicRemove(otherEnd, msgs);
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY:
				return basicSetSecurity(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__URL:
				return getUrl();
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__METHOD:
				return getMethod();
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__HEADERS:
				return getHeaders();
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__FOLLOW_REDIRECTS:
				return isFollowRedirects();
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__CONTENT_TYPE:
				return getContentType();
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY:
				return getSecurity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__URL:
				setUrl((String)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__METHOD:
				setMethod((HTTPMethod)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__HEADERS:
				getHeaders().clear();
				getHeaders().addAll((Collection<? extends HTTPHeader>)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__FOLLOW_REDIRECTS:
				setFollowRedirects((Boolean)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__CONTENT_TYPE:
				setContentType((String)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY:
				setSecurity((Security)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__URL:
				setUrl(URL_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__METHOD:
				setMethod(METHOD_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__HEADERS:
				getHeaders().clear();
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__FOLLOW_REDIRECTS:
				setFollowRedirects(FOLLOW_REDIRECTS_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__CONTENT_TYPE:
				setContentType(CONTENT_TYPE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY:
				setSecurity((Security)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__URL:
				return URL_EDEFAULT == null ? url != null : !URL_EDEFAULT.equals(url);
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__METHOD:
				return method != METHOD_EDEFAULT;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__HEADERS:
				return headers != null && !headers.isEmpty();
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__FOLLOW_REDIRECTS:
				return followRedirects != FOLLOW_REDIRECTS_EDEFAULT;
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__CONTENT_TYPE:
				return CONTENT_TYPE_EDEFAULT == null ? contentType != null : !CONTENT_TYPE_EDEFAULT.equals(contentType);
			case NGSIProtocolsPackage.HTTP_CONFIGURATION__SECURITY:
				return security != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (url: ");
		result.append(url);
		result.append(", method: ");
		result.append(method);
		result.append(", followRedirects: ");
		result.append(followRedirects);
		result.append(", contentType: ");
		result.append(contentType);
		result.append(')');
		return result.toString();
	}

} //HTTPConfigurationImpl
