/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.gecko.emf.ngsi.protocols.HTTPAuthType;
import org.gecko.emf.ngsi.protocols.HTTPSecurity;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>HTTP Security</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl#getAuthType <em>Auth Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl#getBearerToken <em>Bearer Token</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl#getApiKey <em>Api Key</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl#getApiKeyHeader <em>Api Key Header</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.HTTPSecurityImpl#isVerifyHostname <em>Verify Hostname</em>}</li>
 * </ul>
 *
 * @generated
 */
public class HTTPSecurityImpl extends SecurityImpl implements HTTPSecurity {
	/**
	 * The default value of the '{@link #getAuthType() <em>Auth Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAuthType()
	 * @generated
	 * @ordered
	 */
	protected static final HTTPAuthType AUTH_TYPE_EDEFAULT = HTTPAuthType.NONE;

	/**
	 * The cached value of the '{@link #getAuthType() <em>Auth Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAuthType()
	 * @generated
	 * @ordered
	 */
	protected HTTPAuthType authType = AUTH_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getBearerToken() <em>Bearer Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBearerToken()
	 * @generated
	 * @ordered
	 */
	protected static final String BEARER_TOKEN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBearerToken() <em>Bearer Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBearerToken()
	 * @generated
	 * @ordered
	 */
	protected String bearerToken = BEARER_TOKEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getApiKey() <em>Api Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getApiKey()
	 * @generated
	 * @ordered
	 */
	protected static final String API_KEY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getApiKey() <em>Api Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getApiKey()
	 * @generated
	 * @ordered
	 */
	protected String apiKey = API_KEY_EDEFAULT;

	/**
	 * The default value of the '{@link #getApiKeyHeader() <em>Api Key Header</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getApiKeyHeader()
	 * @generated
	 * @ordered
	 */
	protected static final String API_KEY_HEADER_EDEFAULT = "X-API-Key";

	/**
	 * The cached value of the '{@link #getApiKeyHeader() <em>Api Key Header</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getApiKeyHeader()
	 * @generated
	 * @ordered
	 */
	protected String apiKeyHeader = API_KEY_HEADER_EDEFAULT;

	/**
	 * The default value of the '{@link #isVerifyHostname() <em>Verify Hostname</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVerifyHostname()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VERIFY_HOSTNAME_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isVerifyHostname() <em>Verify Hostname</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVerifyHostname()
	 * @generated
	 * @ordered
	 */
	protected boolean verifyHostname = VERIFY_HOSTNAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HTTPSecurityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.HTTP_SECURITY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HTTPAuthType getAuthType() {
		return authType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAuthType(HTTPAuthType newAuthType) {
		HTTPAuthType oldAuthType = authType;
		authType = newAuthType == null ? AUTH_TYPE_EDEFAULT : newAuthType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_SECURITY__AUTH_TYPE, oldAuthType, authType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getBearerToken() {
		return bearerToken;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBearerToken(String newBearerToken) {
		String oldBearerToken = bearerToken;
		bearerToken = newBearerToken;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_SECURITY__BEARER_TOKEN, oldBearerToken, bearerToken));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getApiKey() {
		return apiKey;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setApiKey(String newApiKey) {
		String oldApiKey = apiKey;
		apiKey = newApiKey;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_SECURITY__API_KEY, oldApiKey, apiKey));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getApiKeyHeader() {
		return apiKeyHeader;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setApiKeyHeader(String newApiKeyHeader) {
		String oldApiKeyHeader = apiKeyHeader;
		apiKeyHeader = newApiKeyHeader;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_SECURITY__API_KEY_HEADER, oldApiKeyHeader, apiKeyHeader));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isVerifyHostname() {
		return verifyHostname;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerifyHostname(boolean newVerifyHostname) {
		boolean oldVerifyHostname = verifyHostname;
		verifyHostname = newVerifyHostname;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.HTTP_SECURITY__VERIFY_HOSTNAME, oldVerifyHostname, verifyHostname));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_SECURITY__AUTH_TYPE:
				return getAuthType();
			case NGSIProtocolsPackage.HTTP_SECURITY__BEARER_TOKEN:
				return getBearerToken();
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY:
				return getApiKey();
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY_HEADER:
				return getApiKeyHeader();
			case NGSIProtocolsPackage.HTTP_SECURITY__VERIFY_HOSTNAME:
				return isVerifyHostname();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_SECURITY__AUTH_TYPE:
				setAuthType((HTTPAuthType)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__BEARER_TOKEN:
				setBearerToken((String)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY:
				setApiKey((String)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY_HEADER:
				setApiKeyHeader((String)newValue);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__VERIFY_HOSTNAME:
				setVerifyHostname((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_SECURITY__AUTH_TYPE:
				setAuthType(AUTH_TYPE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__BEARER_TOKEN:
				setBearerToken(BEARER_TOKEN_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY:
				setApiKey(API_KEY_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY_HEADER:
				setApiKeyHeader(API_KEY_HEADER_EDEFAULT);
				return;
			case NGSIProtocolsPackage.HTTP_SECURITY__VERIFY_HOSTNAME:
				setVerifyHostname(VERIFY_HOSTNAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.HTTP_SECURITY__AUTH_TYPE:
				return authType != AUTH_TYPE_EDEFAULT;
			case NGSIProtocolsPackage.HTTP_SECURITY__BEARER_TOKEN:
				return BEARER_TOKEN_EDEFAULT == null ? bearerToken != null : !BEARER_TOKEN_EDEFAULT.equals(bearerToken);
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY:
				return API_KEY_EDEFAULT == null ? apiKey != null : !API_KEY_EDEFAULT.equals(apiKey);
			case NGSIProtocolsPackage.HTTP_SECURITY__API_KEY_HEADER:
				return API_KEY_HEADER_EDEFAULT == null ? apiKeyHeader != null : !API_KEY_HEADER_EDEFAULT.equals(apiKeyHeader);
			case NGSIProtocolsPackage.HTTP_SECURITY__VERIFY_HOSTNAME:
				return verifyHostname != VERIFY_HOSTNAME_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (authType: ");
		result.append(authType);
		result.append(", bearerToken: ");
		result.append(bearerToken);
		result.append(", apiKey: ");
		result.append(apiKey);
		result.append(", apiKeyHeader: ");
		result.append(apiKeyHeader);
		result.append(", verifyHostname: ");
		result.append(verifyHostname);
		result.append(')');
		return result.toString();
	}

} //HTTPSecurityImpl
