/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl;

import org.gecko.emf.ngsi.protocols.KafkaCompressionType;
import org.gecko.emf.ngsi.protocols.KafkaConfiguration;
import org.gecko.emf.ngsi.protocols.KafkaProperty;
import org.gecko.emf.ngsi.protocols.KafkaSecurity;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Kafka Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getBootstrapServers <em>Bootstrap Servers</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getTopic <em>Topic</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getPartition <em>Partition</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getKey <em>Key</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getCompressionType <em>Compression Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getAcks <em>Acks</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaConfigurationImpl#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @generated
 */
public class KafkaConfigurationImpl extends ProtocolConfigurationImpl implements KafkaConfiguration {
	/**
	 * The default value of the '{@link #getBootstrapServers() <em>Bootstrap Servers</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBootstrapServers()
	 * @generated
	 * @ordered
	 */
	protected static final String BOOTSTRAP_SERVERS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBootstrapServers() <em>Bootstrap Servers</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBootstrapServers()
	 * @generated
	 * @ordered
	 */
	protected String bootstrapServers = BOOTSTRAP_SERVERS_EDEFAULT;

	/**
	 * The default value of the '{@link #getTopic() <em>Topic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTopic()
	 * @generated
	 * @ordered
	 */
	protected static final String TOPIC_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTopic() <em>Topic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTopic()
	 * @generated
	 * @ordered
	 */
	protected String topic = TOPIC_EDEFAULT;

	/**
	 * The default value of the '{@link #getPartition() <em>Partition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPartition()
	 * @generated
	 * @ordered
	 */
	protected static final int PARTITION_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPartition() <em>Partition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPartition()
	 * @generated
	 * @ordered
	 */
	protected int partition = PARTITION_EDEFAULT;

	/**
	 * The default value of the '{@link #getKey() <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKey()
	 * @generated
	 * @ordered
	 */
	protected static final String KEY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKey() <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKey()
	 * @generated
	 * @ordered
	 */
	protected String key = KEY_EDEFAULT;

	/**
	 * The default value of the '{@link #getCompressionType() <em>Compression Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCompressionType()
	 * @generated
	 * @ordered
	 */
	protected static final KafkaCompressionType COMPRESSION_TYPE_EDEFAULT = KafkaCompressionType.NONE;

	/**
	 * The cached value of the '{@link #getCompressionType() <em>Compression Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCompressionType()
	 * @generated
	 * @ordered
	 */
	protected KafkaCompressionType compressionType = COMPRESSION_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAcks() <em>Acks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAcks()
	 * @generated
	 * @ordered
	 */
	protected static final String ACKS_EDEFAULT = "1";

	/**
	 * The cached value of the '{@link #getAcks() <em>Acks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAcks()
	 * @generated
	 * @ordered
	 */
	protected String acks = ACKS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<KafkaProperty> properties;

	/**
	 * The cached value of the '{@link #getSecurity() <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecurity()
	 * @generated
	 * @ordered
	 */
	protected KafkaSecurity security;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected KafkaConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.KAFKA_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getBootstrapServers() {
		return bootstrapServers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBootstrapServers(String newBootstrapServers) {
		String oldBootstrapServers = bootstrapServers;
		bootstrapServers = newBootstrapServers;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS, oldBootstrapServers, bootstrapServers));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTopic() {
		return topic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTopic(String newTopic) {
		String oldTopic = topic;
		topic = newTopic;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__TOPIC, oldTopic, topic));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPartition() {
		return partition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPartition(int newPartition) {
		int oldPartition = partition;
		partition = newPartition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__PARTITION, oldPartition, partition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getKey() {
		return key;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKey(String newKey) {
		String oldKey = key;
		key = newKey;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__KEY, oldKey, key));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public KafkaCompressionType getCompressionType() {
		return compressionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCompressionType(KafkaCompressionType newCompressionType) {
		KafkaCompressionType oldCompressionType = compressionType;
		compressionType = newCompressionType == null ? COMPRESSION_TYPE_EDEFAULT : newCompressionType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__COMPRESSION_TYPE, oldCompressionType, compressionType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAcks() {
		return acks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAcks(String newAcks) {
		String oldAcks = acks;
		acks = newAcks;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__ACKS, oldAcks, acks));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<KafkaProperty> getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList<KafkaProperty>(KafkaProperty.class, this, NGSIProtocolsPackage.KAFKA_CONFIGURATION__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public KafkaSecurity getSecurity() {
		return security;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSecurity(KafkaSecurity newSecurity, NotificationChain msgs) {
		KafkaSecurity oldSecurity = security;
		security = newSecurity;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY, oldSecurity, newSecurity);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSecurity(KafkaSecurity newSecurity) {
		if (newSecurity != security) {
			NotificationChain msgs = null;
			if (security != null)
				msgs = ((InternalEObject)security).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY, null, msgs);
			if (newSecurity != null)
				msgs = ((InternalEObject)newSecurity).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY, null, msgs);
			msgs = basicSetSecurity(newSecurity, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY, newSecurity, newSecurity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY:
				return basicSetSecurity(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS:
				return getBootstrapServers();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__TOPIC:
				return getTopic();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PARTITION:
				return getPartition();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__KEY:
				return getKey();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__COMPRESSION_TYPE:
				return getCompressionType();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__ACKS:
				return getAcks();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PROPERTIES:
				return getProperties();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY:
				return getSecurity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS:
				setBootstrapServers((String)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__TOPIC:
				setTopic((String)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PARTITION:
				setPartition((Integer)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__KEY:
				setKey((String)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__COMPRESSION_TYPE:
				setCompressionType((KafkaCompressionType)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__ACKS:
				setAcks((String)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection<? extends KafkaProperty>)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY:
				setSecurity((KafkaSecurity)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS:
				setBootstrapServers(BOOTSTRAP_SERVERS_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__TOPIC:
				setTopic(TOPIC_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PARTITION:
				setPartition(PARTITION_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__KEY:
				setKey(KEY_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__COMPRESSION_TYPE:
				setCompressionType(COMPRESSION_TYPE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__ACKS:
				setAcks(ACKS_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PROPERTIES:
				getProperties().clear();
				return;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY:
				setSecurity((KafkaSecurity)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS:
				return BOOTSTRAP_SERVERS_EDEFAULT == null ? bootstrapServers != null : !BOOTSTRAP_SERVERS_EDEFAULT.equals(bootstrapServers);
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__TOPIC:
				return TOPIC_EDEFAULT == null ? topic != null : !TOPIC_EDEFAULT.equals(topic);
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PARTITION:
				return partition != PARTITION_EDEFAULT;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__KEY:
				return KEY_EDEFAULT == null ? key != null : !KEY_EDEFAULT.equals(key);
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__COMPRESSION_TYPE:
				return compressionType != COMPRESSION_TYPE_EDEFAULT;
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__ACKS:
				return ACKS_EDEFAULT == null ? acks != null : !ACKS_EDEFAULT.equals(acks);
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION__SECURITY:
				return security != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (bootstrapServers: ");
		result.append(bootstrapServers);
		result.append(", topic: ");
		result.append(topic);
		result.append(", partition: ");
		result.append(partition);
		result.append(", key: ");
		result.append(key);
		result.append(", compressionType: ");
		result.append(compressionType);
		result.append(", acks: ");
		result.append(acks);
		result.append(')');
		return result.toString();
	}

} //KafkaConfigurationImpl
