/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.gecko.emf.ngsi.protocols.KafkaSecurity;
import org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;
import org.gecko.emf.ngsi.protocols.SASLMechanism;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Kafka Security</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaSecurityImpl#getSecurityProtocol <em>Security Protocol</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaSecurityImpl#getSaslMechanism <em>Sasl Mechanism</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.KafkaSecurityImpl#getSaslJaasConfig <em>Sasl Jaas Config</em>}</li>
 * </ul>
 *
 * @generated
 */
public class KafkaSecurityImpl extends SecurityImpl implements KafkaSecurity {
	/**
	 * The default value of the '{@link #getSecurityProtocol() <em>Security Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecurityProtocol()
	 * @generated
	 * @ordered
	 */
	protected static final KafkaSecurityProtocol SECURITY_PROTOCOL_EDEFAULT = KafkaSecurityProtocol.PLAINTEXT;

	/**
	 * The cached value of the '{@link #getSecurityProtocol() <em>Security Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecurityProtocol()
	 * @generated
	 * @ordered
	 */
	protected KafkaSecurityProtocol securityProtocol = SECURITY_PROTOCOL_EDEFAULT;

	/**
	 * The default value of the '{@link #getSaslMechanism() <em>Sasl Mechanism</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSaslMechanism()
	 * @generated
	 * @ordered
	 */
	protected static final SASLMechanism SASL_MECHANISM_EDEFAULT = SASLMechanism.PLAIN;

	/**
	 * The cached value of the '{@link #getSaslMechanism() <em>Sasl Mechanism</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSaslMechanism()
	 * @generated
	 * @ordered
	 */
	protected SASLMechanism saslMechanism = SASL_MECHANISM_EDEFAULT;

	/**
	 * The default value of the '{@link #getSaslJaasConfig() <em>Sasl Jaas Config</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSaslJaasConfig()
	 * @generated
	 * @ordered
	 */
	protected static final String SASL_JAAS_CONFIG_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSaslJaasConfig() <em>Sasl Jaas Config</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSaslJaasConfig()
	 * @generated
	 * @ordered
	 */
	protected String saslJaasConfig = SASL_JAAS_CONFIG_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected KafkaSecurityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.KAFKA_SECURITY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public KafkaSecurityProtocol getSecurityProtocol() {
		return securityProtocol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSecurityProtocol(KafkaSecurityProtocol newSecurityProtocol) {
		KafkaSecurityProtocol oldSecurityProtocol = securityProtocol;
		securityProtocol = newSecurityProtocol == null ? SECURITY_PROTOCOL_EDEFAULT : newSecurityProtocol;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_SECURITY__SECURITY_PROTOCOL, oldSecurityProtocol, securityProtocol));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SASLMechanism getSaslMechanism() {
		return saslMechanism;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSaslMechanism(SASLMechanism newSaslMechanism) {
		SASLMechanism oldSaslMechanism = saslMechanism;
		saslMechanism = newSaslMechanism == null ? SASL_MECHANISM_EDEFAULT : newSaslMechanism;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_SECURITY__SASL_MECHANISM, oldSaslMechanism, saslMechanism));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getSaslJaasConfig() {
		return saslJaasConfig;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSaslJaasConfig(String newSaslJaasConfig) {
		String oldSaslJaasConfig = saslJaasConfig;
		saslJaasConfig = newSaslJaasConfig;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.KAFKA_SECURITY__SASL_JAAS_CONFIG, oldSaslJaasConfig, saslJaasConfig));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_SECURITY__SECURITY_PROTOCOL:
				return getSecurityProtocol();
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_MECHANISM:
				return getSaslMechanism();
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_JAAS_CONFIG:
				return getSaslJaasConfig();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_SECURITY__SECURITY_PROTOCOL:
				setSecurityProtocol((KafkaSecurityProtocol)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_MECHANISM:
				setSaslMechanism((SASLMechanism)newValue);
				return;
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_JAAS_CONFIG:
				setSaslJaasConfig((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_SECURITY__SECURITY_PROTOCOL:
				setSecurityProtocol(SECURITY_PROTOCOL_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_MECHANISM:
				setSaslMechanism(SASL_MECHANISM_EDEFAULT);
				return;
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_JAAS_CONFIG:
				setSaslJaasConfig(SASL_JAAS_CONFIG_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.KAFKA_SECURITY__SECURITY_PROTOCOL:
				return securityProtocol != SECURITY_PROTOCOL_EDEFAULT;
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_MECHANISM:
				return saslMechanism != SASL_MECHANISM_EDEFAULT;
			case NGSIProtocolsPackage.KAFKA_SECURITY__SASL_JAAS_CONFIG:
				return SASL_JAAS_CONFIG_EDEFAULT == null ? saslJaasConfig != null : !SASL_JAAS_CONFIG_EDEFAULT.equals(saslJaasConfig);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (securityProtocol: ");
		result.append(securityProtocol);
		result.append(", saslMechanism: ");
		result.append(saslMechanism);
		result.append(", saslJaasConfig: ");
		result.append(saslJaasConfig);
		result.append(')');
		return result.toString();
	}

} //KafkaSecurityImpl
