/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl;

import org.gecko.emf.ngsi.protocols.MQTTConfiguration;
import org.gecko.emf.ngsi.protocols.MQTTQoS;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;
import org.gecko.emf.ngsi.protocols.Security;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>MQTT Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#getBroker <em>Broker</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#getPort <em>Port</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#getTopic <em>Topic</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#getQos <em>Qos</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#isRetain <em>Retain</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#getClientId <em>Client Id</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#isCleanSession <em>Clean Session</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#getKeepAlive <em>Keep Alive</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTConfigurationImpl#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MQTTConfigurationImpl extends ProtocolConfigurationImpl implements MQTTConfiguration {
	/**
	 * The default value of the '{@link #getBroker() <em>Broker</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBroker()
	 * @generated
	 * @ordered
	 */
	protected static final String BROKER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBroker() <em>Broker</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBroker()
	 * @generated
	 * @ordered
	 */
	protected String broker = BROKER_EDEFAULT;

	/**
	 * The default value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected static final int PORT_EDEFAULT = 1883;

	/**
	 * The cached value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected int port = PORT_EDEFAULT;

	/**
	 * The default value of the '{@link #getTopic() <em>Topic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTopic()
	 * @generated
	 * @ordered
	 */
	protected static final String TOPIC_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTopic() <em>Topic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTopic()
	 * @generated
	 * @ordered
	 */
	protected String topic = TOPIC_EDEFAULT;

	/**
	 * The default value of the '{@link #getQos() <em>Qos</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQos()
	 * @generated
	 * @ordered
	 */
	protected static final MQTTQoS QOS_EDEFAULT = MQTTQoS.AT_LEAST_ONCE;

	/**
	 * The cached value of the '{@link #getQos() <em>Qos</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQos()
	 * @generated
	 * @ordered
	 */
	protected MQTTQoS qos = QOS_EDEFAULT;

	/**
	 * The default value of the '{@link #isRetain() <em>Retain</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isRetain()
	 * @generated
	 * @ordered
	 */
	protected static final boolean RETAIN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isRetain() <em>Retain</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isRetain()
	 * @generated
	 * @ordered
	 */
	protected boolean retain = RETAIN_EDEFAULT;

	/**
	 * The default value of the '{@link #getClientId() <em>Client Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClientId()
	 * @generated
	 * @ordered
	 */
	protected static final String CLIENT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getClientId() <em>Client Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClientId()
	 * @generated
	 * @ordered
	 */
	protected String clientId = CLIENT_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #isCleanSession() <em>Clean Session</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCleanSession()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CLEAN_SESSION_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isCleanSession() <em>Clean Session</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCleanSession()
	 * @generated
	 * @ordered
	 */
	protected boolean cleanSession = CLEAN_SESSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getKeepAlive() <em>Keep Alive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeepAlive()
	 * @generated
	 * @ordered
	 */
	protected static final int KEEP_ALIVE_EDEFAULT = 60;

	/**
	 * The cached value of the '{@link #getKeepAlive() <em>Keep Alive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeepAlive()
	 * @generated
	 * @ordered
	 */
	protected int keepAlive = KEEP_ALIVE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSecurity() <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecurity()
	 * @generated
	 * @ordered
	 */
	protected Security security;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MQTTConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.MQTT_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getBroker() {
		return broker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBroker(String newBroker) {
		String oldBroker = broker;
		broker = newBroker;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__BROKER, oldBroker, broker));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPort() {
		return port;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPort(int newPort) {
		int oldPort = port;
		port = newPort;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__PORT, oldPort, port));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTopic() {
		return topic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTopic(String newTopic) {
		String oldTopic = topic;
		topic = newTopic;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__TOPIC, oldTopic, topic));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MQTTQoS getQos() {
		return qos;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setQos(MQTTQoS newQos) {
		MQTTQoS oldQos = qos;
		qos = newQos == null ? QOS_EDEFAULT : newQos;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__QOS, oldQos, qos));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isRetain() {
		return retain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRetain(boolean newRetain) {
		boolean oldRetain = retain;
		retain = newRetain;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__RETAIN, oldRetain, retain));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getClientId() {
		return clientId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setClientId(String newClientId) {
		String oldClientId = clientId;
		clientId = newClientId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__CLIENT_ID, oldClientId, clientId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isCleanSession() {
		return cleanSession;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCleanSession(boolean newCleanSession) {
		boolean oldCleanSession = cleanSession;
		cleanSession = newCleanSession;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__CLEAN_SESSION, oldCleanSession, cleanSession));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getKeepAlive() {
		return keepAlive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKeepAlive(int newKeepAlive) {
		int oldKeepAlive = keepAlive;
		keepAlive = newKeepAlive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__KEEP_ALIVE, oldKeepAlive, keepAlive));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Security getSecurity() {
		return security;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSecurity(Security newSecurity, NotificationChain msgs) {
		Security oldSecurity = security;
		security = newSecurity;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY, oldSecurity, newSecurity);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSecurity(Security newSecurity) {
		if (newSecurity != security) {
			NotificationChain msgs = null;
			if (security != null)
				msgs = ((InternalEObject)security).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY, null, msgs);
			if (newSecurity != null)
				msgs = ((InternalEObject)newSecurity).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY, null, msgs);
			msgs = basicSetSecurity(newSecurity, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY, newSecurity, newSecurity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY:
				return basicSetSecurity(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__BROKER:
				return getBroker();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__PORT:
				return getPort();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__TOPIC:
				return getTopic();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__QOS:
				return getQos();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__RETAIN:
				return isRetain();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLIENT_ID:
				return getClientId();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLEAN_SESSION:
				return isCleanSession();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__KEEP_ALIVE:
				return getKeepAlive();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY:
				return getSecurity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__BROKER:
				setBroker((String)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__PORT:
				setPort((Integer)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__TOPIC:
				setTopic((String)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__QOS:
				setQos((MQTTQoS)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__RETAIN:
				setRetain((Boolean)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLIENT_ID:
				setClientId((String)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLEAN_SESSION:
				setCleanSession((Boolean)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__KEEP_ALIVE:
				setKeepAlive((Integer)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY:
				setSecurity((Security)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__BROKER:
				setBroker(BROKER_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__PORT:
				setPort(PORT_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__TOPIC:
				setTopic(TOPIC_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__QOS:
				setQos(QOS_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__RETAIN:
				setRetain(RETAIN_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLIENT_ID:
				setClientId(CLIENT_ID_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLEAN_SESSION:
				setCleanSession(CLEAN_SESSION_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__KEEP_ALIVE:
				setKeepAlive(KEEP_ALIVE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY:
				setSecurity((Security)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__BROKER:
				return BROKER_EDEFAULT == null ? broker != null : !BROKER_EDEFAULT.equals(broker);
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__PORT:
				return port != PORT_EDEFAULT;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__TOPIC:
				return TOPIC_EDEFAULT == null ? topic != null : !TOPIC_EDEFAULT.equals(topic);
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__QOS:
				return qos != QOS_EDEFAULT;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__RETAIN:
				return retain != RETAIN_EDEFAULT;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLIENT_ID:
				return CLIENT_ID_EDEFAULT == null ? clientId != null : !CLIENT_ID_EDEFAULT.equals(clientId);
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__CLEAN_SESSION:
				return cleanSession != CLEAN_SESSION_EDEFAULT;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__KEEP_ALIVE:
				return keepAlive != KEEP_ALIVE_EDEFAULT;
			case NGSIProtocolsPackage.MQTT_CONFIGURATION__SECURITY:
				return security != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (broker: ");
		result.append(broker);
		result.append(", port: ");
		result.append(port);
		result.append(", topic: ");
		result.append(topic);
		result.append(", qos: ");
		result.append(qos);
		result.append(", retain: ");
		result.append(retain);
		result.append(", clientId: ");
		result.append(clientId);
		result.append(", cleanSession: ");
		result.append(cleanSession);
		result.append(", keepAlive: ");
		result.append(keepAlive);
		result.append(')');
		return result.toString();
	}

} //MQTTConfigurationImpl
