/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.gecko.emf.ngsi.protocols.MQTTSecurity;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>MQTT Security</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTSecurityImpl#getClientCertPath <em>Client Cert Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTSecurityImpl#getTlsVersion <em>Tls Version</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.MQTTSecurityImpl#isInsecureSkipVerify <em>Insecure Skip Verify</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MQTTSecurityImpl extends SecurityImpl implements MQTTSecurity {
	/**
	 * The default value of the '{@link #getClientCertPath() <em>Client Cert Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClientCertPath()
	 * @generated
	 * @ordered
	 */
	protected static final String CLIENT_CERT_PATH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getClientCertPath() <em>Client Cert Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClientCertPath()
	 * @generated
	 * @ordered
	 */
	protected String clientCertPath = CLIENT_CERT_PATH_EDEFAULT;

	/**
	 * The default value of the '{@link #getTlsVersion() <em>Tls Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTlsVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String TLS_VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTlsVersion() <em>Tls Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTlsVersion()
	 * @generated
	 * @ordered
	 */
	protected String tlsVersion = TLS_VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #isInsecureSkipVerify() <em>Insecure Skip Verify</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInsecureSkipVerify()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INSECURE_SKIP_VERIFY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInsecureSkipVerify() <em>Insecure Skip Verify</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInsecureSkipVerify()
	 * @generated
	 * @ordered
	 */
	protected boolean insecureSkipVerify = INSECURE_SKIP_VERIFY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MQTTSecurityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.MQTT_SECURITY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getClientCertPath() {
		return clientCertPath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setClientCertPath(String newClientCertPath) {
		String oldClientCertPath = clientCertPath;
		clientCertPath = newClientCertPath;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_SECURITY__CLIENT_CERT_PATH, oldClientCertPath, clientCertPath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTlsVersion() {
		return tlsVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTlsVersion(String newTlsVersion) {
		String oldTlsVersion = tlsVersion;
		tlsVersion = newTlsVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_SECURITY__TLS_VERSION, oldTlsVersion, tlsVersion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isInsecureSkipVerify() {
		return insecureSkipVerify;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInsecureSkipVerify(boolean newInsecureSkipVerify) {
		boolean oldInsecureSkipVerify = insecureSkipVerify;
		insecureSkipVerify = newInsecureSkipVerify;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.MQTT_SECURITY__INSECURE_SKIP_VERIFY, oldInsecureSkipVerify, insecureSkipVerify));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_SECURITY__CLIENT_CERT_PATH:
				return getClientCertPath();
			case NGSIProtocolsPackage.MQTT_SECURITY__TLS_VERSION:
				return getTlsVersion();
			case NGSIProtocolsPackage.MQTT_SECURITY__INSECURE_SKIP_VERIFY:
				return isInsecureSkipVerify();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_SECURITY__CLIENT_CERT_PATH:
				setClientCertPath((String)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_SECURITY__TLS_VERSION:
				setTlsVersion((String)newValue);
				return;
			case NGSIProtocolsPackage.MQTT_SECURITY__INSECURE_SKIP_VERIFY:
				setInsecureSkipVerify((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_SECURITY__CLIENT_CERT_PATH:
				setClientCertPath(CLIENT_CERT_PATH_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_SECURITY__TLS_VERSION:
				setTlsVersion(TLS_VERSION_EDEFAULT);
				return;
			case NGSIProtocolsPackage.MQTT_SECURITY__INSECURE_SKIP_VERIFY:
				setInsecureSkipVerify(INSECURE_SKIP_VERIFY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.MQTT_SECURITY__CLIENT_CERT_PATH:
				return CLIENT_CERT_PATH_EDEFAULT == null ? clientCertPath != null : !CLIENT_CERT_PATH_EDEFAULT.equals(clientCertPath);
			case NGSIProtocolsPackage.MQTT_SECURITY__TLS_VERSION:
				return TLS_VERSION_EDEFAULT == null ? tlsVersion != null : !TLS_VERSION_EDEFAULT.equals(tlsVersion);
			case NGSIProtocolsPackage.MQTT_SECURITY__INSECURE_SKIP_VERIFY:
				return insecureSkipVerify != INSECURE_SKIP_VERIFY_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (clientCertPath: ");
		result.append(clientCertPath);
		result.append(", tlsVersion: ");
		result.append(tlsVersion);
		result.append(", insecureSkipVerify: ");
		result.append(insecureSkipVerify);
		result.append(')');
		return result.toString();
	}

} //MQTTSecurityImpl
