/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.gecko.emf.ngsi.protocols.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class NGSIProtocolsFactoryImpl extends EFactoryImpl implements NGSIProtocolsFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static NGSIProtocolsFactory init() {
		try {
			NGSIProtocolsFactory theNGSIProtocolsFactory = (NGSIProtocolsFactory)EPackage.Registry.INSTANCE.getEFactory(NGSIProtocolsPackage.eNS_URI);
			if (theNGSIProtocolsFactory != null) {
				return theNGSIProtocolsFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new NGSIProtocolsFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSIProtocolsFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case NGSIProtocolsPackage.HTTP_CONFIGURATION: return createHTTPConfiguration();
			case NGSIProtocolsPackage.MQTT_CONFIGURATION: return createMQTTConfiguration();
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION: return createWebSocketConfiguration();
			case NGSIProtocolsPackage.KAFKA_CONFIGURATION: return createKafkaConfiguration();
			case NGSIProtocolsPackage.AMQP_CONFIGURATION: return createAMQPConfiguration();
			case NGSIProtocolsPackage.HTTP_SECURITY: return createHTTPSecurity();
			case NGSIProtocolsPackage.MQTT_SECURITY: return createMQTTSecurity();
			case NGSIProtocolsPackage.KAFKA_SECURITY: return createKafkaSecurity();
			case NGSIProtocolsPackage.HTTP_HEADER: return createHTTPHeader();
			case NGSIProtocolsPackage.KAFKA_PROPERTY: return createKafkaProperty();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case NGSIProtocolsPackage.HTTP_METHOD:
				return createHTTPMethodFromString(eDataType, initialValue);
			case NGSIProtocolsPackage.HTTP_AUTH_TYPE:
				return createHTTPAuthTypeFromString(eDataType, initialValue);
			case NGSIProtocolsPackage.MQTT_QO_S:
				return createMQTTQoSFromString(eDataType, initialValue);
			case NGSIProtocolsPackage.KAFKA_COMPRESSION_TYPE:
				return createKafkaCompressionTypeFromString(eDataType, initialValue);
			case NGSIProtocolsPackage.KAFKA_SECURITY_PROTOCOL:
				return createKafkaSecurityProtocolFromString(eDataType, initialValue);
			case NGSIProtocolsPackage.SASL_MECHANISM:
				return createSASLMechanismFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case NGSIProtocolsPackage.HTTP_METHOD:
				return convertHTTPMethodToString(eDataType, instanceValue);
			case NGSIProtocolsPackage.HTTP_AUTH_TYPE:
				return convertHTTPAuthTypeToString(eDataType, instanceValue);
			case NGSIProtocolsPackage.MQTT_QO_S:
				return convertMQTTQoSToString(eDataType, instanceValue);
			case NGSIProtocolsPackage.KAFKA_COMPRESSION_TYPE:
				return convertKafkaCompressionTypeToString(eDataType, instanceValue);
			case NGSIProtocolsPackage.KAFKA_SECURITY_PROTOCOL:
				return convertKafkaSecurityProtocolToString(eDataType, instanceValue);
			case NGSIProtocolsPackage.SASL_MECHANISM:
				return convertSASLMechanismToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HTTPConfiguration createHTTPConfiguration() {
		HTTPConfigurationImpl httpConfiguration = new HTTPConfigurationImpl();
		return httpConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MQTTConfiguration createMQTTConfiguration() {
		MQTTConfigurationImpl mqttConfiguration = new MQTTConfigurationImpl();
		return mqttConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public WebSocketConfiguration createWebSocketConfiguration() {
		WebSocketConfigurationImpl webSocketConfiguration = new WebSocketConfigurationImpl();
		return webSocketConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public KafkaConfiguration createKafkaConfiguration() {
		KafkaConfigurationImpl kafkaConfiguration = new KafkaConfigurationImpl();
		return kafkaConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AMQPConfiguration createAMQPConfiguration() {
		AMQPConfigurationImpl amqpConfiguration = new AMQPConfigurationImpl();
		return amqpConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HTTPSecurity createHTTPSecurity() {
		HTTPSecurityImpl httpSecurity = new HTTPSecurityImpl();
		return httpSecurity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MQTTSecurity createMQTTSecurity() {
		MQTTSecurityImpl mqttSecurity = new MQTTSecurityImpl();
		return mqttSecurity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public KafkaSecurity createKafkaSecurity() {
		KafkaSecurityImpl kafkaSecurity = new KafkaSecurityImpl();
		return kafkaSecurity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HTTPHeader createHTTPHeader() {
		HTTPHeaderImpl httpHeader = new HTTPHeaderImpl();
		return httpHeader;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public KafkaProperty createKafkaProperty() {
		KafkaPropertyImpl kafkaProperty = new KafkaPropertyImpl();
		return kafkaProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HTTPMethod createHTTPMethodFromString(EDataType eDataType, String initialValue) {
		HTTPMethod result = HTTPMethod.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertHTTPMethodToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HTTPAuthType createHTTPAuthTypeFromString(EDataType eDataType, String initialValue) {
		HTTPAuthType result = HTTPAuthType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertHTTPAuthTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MQTTQoS createMQTTQoSFromString(EDataType eDataType, String initialValue) {
		MQTTQoS result = MQTTQoS.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertMQTTQoSToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KafkaCompressionType createKafkaCompressionTypeFromString(EDataType eDataType, String initialValue) {
		KafkaCompressionType result = KafkaCompressionType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertKafkaCompressionTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KafkaSecurityProtocol createKafkaSecurityProtocolFromString(EDataType eDataType, String initialValue) {
		KafkaSecurityProtocol result = KafkaSecurityProtocol.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertKafkaSecurityProtocolToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SASLMechanism createSASLMechanismFromString(EDataType eDataType, String initialValue) {
		SASLMechanism result = SASLMechanism.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertSASLMechanismToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIProtocolsPackage getNGSIProtocolsPackage() {
		return (NGSIProtocolsPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static NGSIProtocolsPackage getPackage() {
		return NGSIProtocolsPackage.eINSTANCE;
	}

} //NGSIProtocolsFactoryImpl
