/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.emf.ngsi.NGSIPackage;

import org.gecko.emf.ngsi.impl.NGSIPackageImpl;

import org.gecko.emf.ngsi.protocols.AMQPConfiguration;
import org.gecko.emf.ngsi.protocols.HTTPAuthType;
import org.gecko.emf.ngsi.protocols.HTTPConfiguration;
import org.gecko.emf.ngsi.protocols.HTTPHeader;
import org.gecko.emf.ngsi.protocols.HTTPMethod;
import org.gecko.emf.ngsi.protocols.HTTPSecurity;
import org.gecko.emf.ngsi.protocols.KafkaCompressionType;
import org.gecko.emf.ngsi.protocols.KafkaConfiguration;
import org.gecko.emf.ngsi.protocols.KafkaProperty;
import org.gecko.emf.ngsi.protocols.KafkaSecurity;
import org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol;
import org.gecko.emf.ngsi.protocols.MQTTConfiguration;
import org.gecko.emf.ngsi.protocols.MQTTQoS;
import org.gecko.emf.ngsi.protocols.MQTTSecurity;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsFactory;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;
import org.gecko.emf.ngsi.protocols.SASLMechanism;
import org.gecko.emf.ngsi.protocols.Security;
import org.gecko.emf.ngsi.protocols.WebSocketConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class NGSIProtocolsPackageImpl extends EPackageImpl implements NGSIProtocolsPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass httpConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mqttConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass webSocketConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass kafkaConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass amqpConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass securityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass httpSecurityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mqttSecurityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass kafkaSecurityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass httpHeaderEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass kafkaPropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum httpMethodEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum httpAuthTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum mqttQoSEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum kafkaCompressionTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum kafkaSecurityProtocolEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum saslMechanismEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private NGSIProtocolsPackageImpl() {
		super(eNS_URI, NGSIProtocolsFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link NGSIProtocolsPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static NGSIProtocolsPackage init() {
		if (isInited) return (NGSIProtocolsPackage)EPackage.Registry.INSTANCE.getEPackage(NGSIProtocolsPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredNGSIProtocolsPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		NGSIProtocolsPackageImpl theNGSIProtocolsPackage = registeredNGSIProtocolsPackage instanceof NGSIProtocolsPackageImpl ? (NGSIProtocolsPackageImpl)registeredNGSIProtocolsPackage : new NGSIProtocolsPackageImpl();

		isInited = true;

		// Obtain or create and register interdependencies
		Object registeredPackage = EPackage.Registry.INSTANCE.getEPackage(NGSIPackage.eNS_URI);
		NGSIPackageImpl theNGSIPackage = (NGSIPackageImpl)(registeredPackage instanceof NGSIPackageImpl ? registeredPackage : NGSIPackage.eINSTANCE);

		// Create package meta-data objects
		theNGSIProtocolsPackage.createPackageContents();
		theNGSIPackage.createPackageContents();

		// Initialize created meta-data
		theNGSIProtocolsPackage.initializePackageContents();
		theNGSIPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theNGSIProtocolsPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(NGSIProtocolsPackage.eNS_URI, theNGSIProtocolsPackage);
		return theNGSIProtocolsPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getHTTPConfiguration() {
		return httpConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPConfiguration_Url() {
		return (EAttribute)httpConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPConfiguration_Method() {
		return (EAttribute)httpConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHTTPConfiguration_Headers() {
		return (EReference)httpConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPConfiguration_FollowRedirects() {
		return (EAttribute)httpConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPConfiguration_ContentType() {
		return (EAttribute)httpConfigurationEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHTTPConfiguration_Security() {
		return (EReference)httpConfigurationEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMQTTConfiguration() {
		return mqttConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_Broker() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_Port() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_Topic() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_Qos() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_Retain() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_ClientId() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_CleanSession() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTConfiguration_KeepAlive() {
		return (EAttribute)mqttConfigurationEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMQTTConfiguration_Security() {
		return (EReference)mqttConfigurationEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getWebSocketConfiguration() {
		return webSocketConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getWebSocketConfiguration_Url() {
		return (EAttribute)webSocketConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getWebSocketConfiguration_Subprotocol() {
		return (EAttribute)webSocketConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getWebSocketConfiguration_PingInterval() {
		return (EAttribute)webSocketConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getWebSocketConfiguration_MaxFrameSize() {
		return (EAttribute)webSocketConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getWebSocketConfiguration_Headers() {
		return (EReference)webSocketConfigurationEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getWebSocketConfiguration_Security() {
		return (EReference)webSocketConfigurationEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getKafkaConfiguration() {
		return kafkaConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaConfiguration_BootstrapServers() {
		return (EAttribute)kafkaConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaConfiguration_Topic() {
		return (EAttribute)kafkaConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaConfiguration_Partition() {
		return (EAttribute)kafkaConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaConfiguration_Key() {
		return (EAttribute)kafkaConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaConfiguration_CompressionType() {
		return (EAttribute)kafkaConfigurationEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaConfiguration_Acks() {
		return (EAttribute)kafkaConfigurationEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getKafkaConfiguration_Properties() {
		return (EReference)kafkaConfigurationEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getKafkaConfiguration_Security() {
		return (EReference)kafkaConfigurationEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAMQPConfiguration() {
		return amqpConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_Host() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_Port() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_VirtualHost() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_Exchange() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_RoutingKey() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_Queue() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_Durable() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAMQPConfiguration_AutoDelete() {
		return (EAttribute)amqpConfigurationEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAMQPConfiguration_Security() {
		return (EReference)amqpConfigurationEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSecurity() {
		return securityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_Username() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_Password() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_KeystorePath() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_KeyPath() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_KeystorePassword() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_TruststorePath() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_TruststorePassword() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSecurity_UseSSL() {
		return (EAttribute)securityEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getHTTPSecurity() {
		return httpSecurityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPSecurity_AuthType() {
		return (EAttribute)httpSecurityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPSecurity_BearerToken() {
		return (EAttribute)httpSecurityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPSecurity_ApiKey() {
		return (EAttribute)httpSecurityEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPSecurity_ApiKeyHeader() {
		return (EAttribute)httpSecurityEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPSecurity_VerifyHostname() {
		return (EAttribute)httpSecurityEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMQTTSecurity() {
		return mqttSecurityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTSecurity_ClientCertPath() {
		return (EAttribute)mqttSecurityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTSecurity_TlsVersion() {
		return (EAttribute)mqttSecurityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMQTTSecurity_InsecureSkipVerify() {
		return (EAttribute)mqttSecurityEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getKafkaSecurity() {
		return kafkaSecurityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaSecurity_SecurityProtocol() {
		return (EAttribute)kafkaSecurityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaSecurity_SaslMechanism() {
		return (EAttribute)kafkaSecurityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaSecurity_SaslJaasConfig() {
		return (EAttribute)kafkaSecurityEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getHTTPHeader() {
		return httpHeaderEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPHeader_Name() {
		return (EAttribute)httpHeaderEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHTTPHeader_Value() {
		return (EAttribute)httpHeaderEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getKafkaProperty() {
		return kafkaPropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaProperty_Key() {
		return (EAttribute)kafkaPropertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getKafkaProperty_Value() {
		return (EAttribute)kafkaPropertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getHTTPMethod() {
		return httpMethodEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getHTTPAuthType() {
		return httpAuthTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getMQTTQoS() {
		return mqttQoSEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getKafkaCompressionType() {
		return kafkaCompressionTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getKafkaSecurityProtocol() {
		return kafkaSecurityProtocolEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getSASLMechanism() {
		return saslMechanismEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIProtocolsFactory getNGSIProtocolsFactory() {
		return (NGSIProtocolsFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		httpConfigurationEClass = createEClass(HTTP_CONFIGURATION);
		createEAttribute(httpConfigurationEClass, HTTP_CONFIGURATION__URL);
		createEAttribute(httpConfigurationEClass, HTTP_CONFIGURATION__METHOD);
		createEReference(httpConfigurationEClass, HTTP_CONFIGURATION__HEADERS);
		createEAttribute(httpConfigurationEClass, HTTP_CONFIGURATION__FOLLOW_REDIRECTS);
		createEAttribute(httpConfigurationEClass, HTTP_CONFIGURATION__CONTENT_TYPE);
		createEReference(httpConfigurationEClass, HTTP_CONFIGURATION__SECURITY);

		mqttConfigurationEClass = createEClass(MQTT_CONFIGURATION);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__BROKER);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__PORT);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__TOPIC);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__QOS);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__RETAIN);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__CLIENT_ID);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__CLEAN_SESSION);
		createEAttribute(mqttConfigurationEClass, MQTT_CONFIGURATION__KEEP_ALIVE);
		createEReference(mqttConfigurationEClass, MQTT_CONFIGURATION__SECURITY);

		webSocketConfigurationEClass = createEClass(WEB_SOCKET_CONFIGURATION);
		createEAttribute(webSocketConfigurationEClass, WEB_SOCKET_CONFIGURATION__URL);
		createEAttribute(webSocketConfigurationEClass, WEB_SOCKET_CONFIGURATION__SUBPROTOCOL);
		createEAttribute(webSocketConfigurationEClass, WEB_SOCKET_CONFIGURATION__PING_INTERVAL);
		createEAttribute(webSocketConfigurationEClass, WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE);
		createEReference(webSocketConfigurationEClass, WEB_SOCKET_CONFIGURATION__HEADERS);
		createEReference(webSocketConfigurationEClass, WEB_SOCKET_CONFIGURATION__SECURITY);

		kafkaConfigurationEClass = createEClass(KAFKA_CONFIGURATION);
		createEAttribute(kafkaConfigurationEClass, KAFKA_CONFIGURATION__BOOTSTRAP_SERVERS);
		createEAttribute(kafkaConfigurationEClass, KAFKA_CONFIGURATION__TOPIC);
		createEAttribute(kafkaConfigurationEClass, KAFKA_CONFIGURATION__PARTITION);
		createEAttribute(kafkaConfigurationEClass, KAFKA_CONFIGURATION__KEY);
		createEAttribute(kafkaConfigurationEClass, KAFKA_CONFIGURATION__COMPRESSION_TYPE);
		createEAttribute(kafkaConfigurationEClass, KAFKA_CONFIGURATION__ACKS);
		createEReference(kafkaConfigurationEClass, KAFKA_CONFIGURATION__PROPERTIES);
		createEReference(kafkaConfigurationEClass, KAFKA_CONFIGURATION__SECURITY);

		amqpConfigurationEClass = createEClass(AMQP_CONFIGURATION);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__HOST);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__PORT);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__VIRTUAL_HOST);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__EXCHANGE);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__ROUTING_KEY);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__QUEUE);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__DURABLE);
		createEAttribute(amqpConfigurationEClass, AMQP_CONFIGURATION__AUTO_DELETE);
		createEReference(amqpConfigurationEClass, AMQP_CONFIGURATION__SECURITY);

		securityEClass = createEClass(SECURITY);
		createEAttribute(securityEClass, SECURITY__USERNAME);
		createEAttribute(securityEClass, SECURITY__PASSWORD);
		createEAttribute(securityEClass, SECURITY__KEYSTORE_PATH);
		createEAttribute(securityEClass, SECURITY__KEY_PATH);
		createEAttribute(securityEClass, SECURITY__KEYSTORE_PASSWORD);
		createEAttribute(securityEClass, SECURITY__TRUSTSTORE_PATH);
		createEAttribute(securityEClass, SECURITY__TRUSTSTORE_PASSWORD);
		createEAttribute(securityEClass, SECURITY__USE_SSL);

		httpSecurityEClass = createEClass(HTTP_SECURITY);
		createEAttribute(httpSecurityEClass, HTTP_SECURITY__AUTH_TYPE);
		createEAttribute(httpSecurityEClass, HTTP_SECURITY__BEARER_TOKEN);
		createEAttribute(httpSecurityEClass, HTTP_SECURITY__API_KEY);
		createEAttribute(httpSecurityEClass, HTTP_SECURITY__API_KEY_HEADER);
		createEAttribute(httpSecurityEClass, HTTP_SECURITY__VERIFY_HOSTNAME);

		mqttSecurityEClass = createEClass(MQTT_SECURITY);
		createEAttribute(mqttSecurityEClass, MQTT_SECURITY__CLIENT_CERT_PATH);
		createEAttribute(mqttSecurityEClass, MQTT_SECURITY__TLS_VERSION);
		createEAttribute(mqttSecurityEClass, MQTT_SECURITY__INSECURE_SKIP_VERIFY);

		kafkaSecurityEClass = createEClass(KAFKA_SECURITY);
		createEAttribute(kafkaSecurityEClass, KAFKA_SECURITY__SECURITY_PROTOCOL);
		createEAttribute(kafkaSecurityEClass, KAFKA_SECURITY__SASL_MECHANISM);
		createEAttribute(kafkaSecurityEClass, KAFKA_SECURITY__SASL_JAAS_CONFIG);

		httpHeaderEClass = createEClass(HTTP_HEADER);
		createEAttribute(httpHeaderEClass, HTTP_HEADER__NAME);
		createEAttribute(httpHeaderEClass, HTTP_HEADER__VALUE);

		kafkaPropertyEClass = createEClass(KAFKA_PROPERTY);
		createEAttribute(kafkaPropertyEClass, KAFKA_PROPERTY__KEY);
		createEAttribute(kafkaPropertyEClass, KAFKA_PROPERTY__VALUE);

		// Create enums
		httpMethodEEnum = createEEnum(HTTP_METHOD);
		httpAuthTypeEEnum = createEEnum(HTTP_AUTH_TYPE);
		mqttQoSEEnum = createEEnum(MQTT_QO_S);
		kafkaCompressionTypeEEnum = createEEnum(KAFKA_COMPRESSION_TYPE);
		kafkaSecurityProtocolEEnum = createEEnum(KAFKA_SECURITY_PROTOCOL);
		saslMechanismEEnum = createEEnum(SASL_MECHANISM);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		NGSIPackage theNGSIPackage = (NGSIPackage)EPackage.Registry.INSTANCE.getEPackage(NGSIPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		httpConfigurationEClass.getESuperTypes().add(theNGSIPackage.getProtocolConfiguration());
		mqttConfigurationEClass.getESuperTypes().add(theNGSIPackage.getProtocolConfiguration());
		webSocketConfigurationEClass.getESuperTypes().add(theNGSIPackage.getProtocolConfiguration());
		kafkaConfigurationEClass.getESuperTypes().add(theNGSIPackage.getProtocolConfiguration());
		amqpConfigurationEClass.getESuperTypes().add(theNGSIPackage.getProtocolConfiguration());
		httpSecurityEClass.getESuperTypes().add(this.getSecurity());
		mqttSecurityEClass.getESuperTypes().add(this.getSecurity());
		kafkaSecurityEClass.getESuperTypes().add(this.getSecurity());

		// Initialize classes, features, and operations; add parameters
		initEClass(httpConfigurationEClass, HTTPConfiguration.class, "HTTPConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHTTPConfiguration_Url(), ecorePackage.getEString(), "url", null, 1, 1, HTTPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPConfiguration_Method(), this.getHTTPMethod(), "method", "POST", 0, 1, HTTPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHTTPConfiguration_Headers(), this.getHTTPHeader(), null, "headers", null, 0, -1, HTTPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPConfiguration_FollowRedirects(), ecorePackage.getEBoolean(), "followRedirects", "true", 0, 1, HTTPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPConfiguration_ContentType(), ecorePackage.getEString(), "contentType", "application/json", 0, 1, HTTPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHTTPConfiguration_Security(), this.getSecurity(), null, "security", null, 0, 1, HTTPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mqttConfigurationEClass, MQTTConfiguration.class, "MQTTConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMQTTConfiguration_Broker(), ecorePackage.getEString(), "broker", null, 1, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTConfiguration_Port(), ecorePackage.getEInt(), "port", "1883", 0, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTConfiguration_Topic(), ecorePackage.getEString(), "topic", null, 1, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTConfiguration_Qos(), this.getMQTTQoS(), "qos", "AT_LEAST_ONCE", 0, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTConfiguration_Retain(), ecorePackage.getEBoolean(), "retain", "false", 0, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTConfiguration_ClientId(), ecorePackage.getEString(), "clientId", null, 0, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTConfiguration_CleanSession(), ecorePackage.getEBoolean(), "cleanSession", "true", 0, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTConfiguration_KeepAlive(), ecorePackage.getEInt(), "keepAlive", "60", 0, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMQTTConfiguration_Security(), this.getSecurity(), null, "security", null, 0, 1, MQTTConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(webSocketConfigurationEClass, WebSocketConfiguration.class, "WebSocketConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getWebSocketConfiguration_Url(), ecorePackage.getEString(), "url", null, 1, 1, WebSocketConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getWebSocketConfiguration_Subprotocol(), ecorePackage.getEString(), "subprotocol", null, 0, 1, WebSocketConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getWebSocketConfiguration_PingInterval(), ecorePackage.getEInt(), "pingInterval", "30000", 0, 1, WebSocketConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getWebSocketConfiguration_MaxFrameSize(), ecorePackage.getEInt(), "maxFrameSize", "65536", 0, 1, WebSocketConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getWebSocketConfiguration_Headers(), this.getHTTPHeader(), null, "headers", null, 0, -1, WebSocketConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getWebSocketConfiguration_Security(), this.getSecurity(), null, "security", null, 0, 1, WebSocketConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(kafkaConfigurationEClass, KafkaConfiguration.class, "KafkaConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getKafkaConfiguration_BootstrapServers(), ecorePackage.getEString(), "bootstrapServers", null, 1, 1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaConfiguration_Topic(), ecorePackage.getEString(), "topic", null, 1, 1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaConfiguration_Partition(), ecorePackage.getEInt(), "partition", null, 0, 1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaConfiguration_Key(), ecorePackage.getEString(), "key", null, 0, 1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaConfiguration_CompressionType(), this.getKafkaCompressionType(), "compressionType", "none", 0, 1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaConfiguration_Acks(), ecorePackage.getEString(), "acks", "1", 0, 1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getKafkaConfiguration_Properties(), this.getKafkaProperty(), null, "properties", null, 0, -1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getKafkaConfiguration_Security(), this.getKafkaSecurity(), null, "security", null, 0, 1, KafkaConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(amqpConfigurationEClass, AMQPConfiguration.class, "AMQPConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAMQPConfiguration_Host(), ecorePackage.getEString(), "host", null, 1, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAMQPConfiguration_Port(), ecorePackage.getEInt(), "port", "5672", 0, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAMQPConfiguration_VirtualHost(), ecorePackage.getEString(), "virtualHost", "/", 0, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAMQPConfiguration_Exchange(), ecorePackage.getEString(), "exchange", null, 1, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAMQPConfiguration_RoutingKey(), ecorePackage.getEString(), "routingKey", null, 0, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAMQPConfiguration_Queue(), ecorePackage.getEString(), "queue", null, 0, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAMQPConfiguration_Durable(), ecorePackage.getEBoolean(), "durable", "true", 0, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAMQPConfiguration_AutoDelete(), ecorePackage.getEBoolean(), "autoDelete", "false", 0, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAMQPConfiguration_Security(), this.getSecurity(), null, "security", null, 0, 1, AMQPConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(securityEClass, Security.class, "Security", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSecurity_Username(), ecorePackage.getEString(), "username", null, 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSecurity_Password(), ecorePackage.getEString(), "password", null, 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSecurity_KeystorePath(), ecorePackage.getEString(), "keystorePath", null, 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSecurity_KeyPath(), ecorePackage.getEString(), "keyPath", null, 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSecurity_KeystorePassword(), ecorePackage.getEString(), "keystorePassword", null, 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSecurity_TruststorePath(), ecorePackage.getEString(), "truststorePath", null, 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSecurity_TruststorePassword(), ecorePackage.getEString(), "truststorePassword", null, 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSecurity_UseSSL(), ecorePackage.getEBoolean(), "useSSL", "false", 0, 1, Security.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(httpSecurityEClass, HTTPSecurity.class, "HTTPSecurity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHTTPSecurity_AuthType(), this.getHTTPAuthType(), "authType", "none", 0, 1, HTTPSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPSecurity_BearerToken(), ecorePackage.getEString(), "bearerToken", null, 0, 1, HTTPSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPSecurity_ApiKey(), ecorePackage.getEString(), "apiKey", null, 0, 1, HTTPSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPSecurity_ApiKeyHeader(), ecorePackage.getEString(), "apiKeyHeader", "X-API-Key", 0, 1, HTTPSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPSecurity_VerifyHostname(), ecorePackage.getEBoolean(), "verifyHostname", "true", 0, 1, HTTPSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mqttSecurityEClass, MQTTSecurity.class, "MQTTSecurity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMQTTSecurity_ClientCertPath(), ecorePackage.getEString(), "clientCertPath", null, 0, 1, MQTTSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTSecurity_TlsVersion(), ecorePackage.getEString(), "tlsVersion", null, 0, 1, MQTTSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMQTTSecurity_InsecureSkipVerify(), ecorePackage.getEBoolean(), "insecureSkipVerify", "false", 0, 1, MQTTSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(kafkaSecurityEClass, KafkaSecurity.class, "KafkaSecurity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getKafkaSecurity_SecurityProtocol(), this.getKafkaSecurityProtocol(), "securityProtocol", "PLAINTEXT", 0, 1, KafkaSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaSecurity_SaslMechanism(), this.getSASLMechanism(), "saslMechanism", null, 0, 1, KafkaSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaSecurity_SaslJaasConfig(), ecorePackage.getEString(), "saslJaasConfig", null, 0, 1, KafkaSecurity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(httpHeaderEClass, HTTPHeader.class, "HTTPHeader", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHTTPHeader_Name(), ecorePackage.getEString(), "name", null, 1, 1, HTTPHeader.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHTTPHeader_Value(), ecorePackage.getEString(), "value", null, 1, 1, HTTPHeader.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(kafkaPropertyEClass, KafkaProperty.class, "KafkaProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getKafkaProperty_Key(), ecorePackage.getEString(), "key", null, 1, 1, KafkaProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getKafkaProperty_Value(), ecorePackage.getEString(), "value", null, 1, 1, KafkaProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(httpMethodEEnum, HTTPMethod.class, "HTTPMethod");
		addEEnumLiteral(httpMethodEEnum, HTTPMethod.GET);
		addEEnumLiteral(httpMethodEEnum, HTTPMethod.POST);
		addEEnumLiteral(httpMethodEEnum, HTTPMethod.PUT);
		addEEnumLiteral(httpMethodEEnum, HTTPMethod.DELETE);
		addEEnumLiteral(httpMethodEEnum, HTTPMethod.PATCH);

		initEEnum(httpAuthTypeEEnum, HTTPAuthType.class, "HTTPAuthType");
		addEEnumLiteral(httpAuthTypeEEnum, HTTPAuthType.NONE);
		addEEnumLiteral(httpAuthTypeEEnum, HTTPAuthType.BASIC);
		addEEnumLiteral(httpAuthTypeEEnum, HTTPAuthType.BEARER);
		addEEnumLiteral(httpAuthTypeEEnum, HTTPAuthType.API_KEY);
		addEEnumLiteral(httpAuthTypeEEnum, HTTPAuthType.DIGEST);
		addEEnumLiteral(httpAuthTypeEEnum, HTTPAuthType.OAUTH2);

		initEEnum(mqttQoSEEnum, MQTTQoS.class, "MQTTQoS");
		addEEnumLiteral(mqttQoSEEnum, MQTTQoS.AT_MOST_ONCE);
		addEEnumLiteral(mqttQoSEEnum, MQTTQoS.AT_LEAST_ONCE);
		addEEnumLiteral(mqttQoSEEnum, MQTTQoS.EXACTLY_ONCE);

		initEEnum(kafkaCompressionTypeEEnum, KafkaCompressionType.class, "KafkaCompressionType");
		addEEnumLiteral(kafkaCompressionTypeEEnum, KafkaCompressionType.NONE);
		addEEnumLiteral(kafkaCompressionTypeEEnum, KafkaCompressionType.GZIP);
		addEEnumLiteral(kafkaCompressionTypeEEnum, KafkaCompressionType.SNAPPY);
		addEEnumLiteral(kafkaCompressionTypeEEnum, KafkaCompressionType.LZ4);
		addEEnumLiteral(kafkaCompressionTypeEEnum, KafkaCompressionType.ZSTD);

		initEEnum(kafkaSecurityProtocolEEnum, KafkaSecurityProtocol.class, "KafkaSecurityProtocol");
		addEEnumLiteral(kafkaSecurityProtocolEEnum, KafkaSecurityProtocol.PLAINTEXT);
		addEEnumLiteral(kafkaSecurityProtocolEEnum, KafkaSecurityProtocol.SSL);
		addEEnumLiteral(kafkaSecurityProtocolEEnum, KafkaSecurityProtocol.SASL_PLAINTEXT);
		addEEnumLiteral(kafkaSecurityProtocolEEnum, KafkaSecurityProtocol.SASL_SSL);

		initEEnum(saslMechanismEEnum, SASLMechanism.class, "SASLMechanism");
		addEEnumLiteral(saslMechanismEEnum, SASLMechanism.PLAIN);
		addEEnumLiteral(saslMechanismEEnum, SASLMechanism.SCRAM_SHA_256);
		addEEnumLiteral(saslMechanismEEnum, SASLMechanism.SCRAM_SHA_512);
		addEEnumLiteral(saslMechanismEEnum, SASLMechanism.GSSAPI);
		addEEnumLiteral(saslMechanismEEnum, SASLMechanism.OAUTHBEARER);

		// Create resource
		createResource(eNS_URI);
	}

} //NGSIProtocolsPackageImpl
