/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;
import org.gecko.emf.ngsi.protocols.Security;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Security</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#getUsername <em>Username</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#getPassword <em>Password</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#getKeystorePath <em>Keystore Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#getKeyPath <em>Key Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#getKeystorePassword <em>Keystore Password</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#getTruststorePath <em>Truststore Path</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#getTruststorePassword <em>Truststore Password</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.SecurityImpl#isUseSSL <em>Use SSL</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class SecurityImpl extends MinimalEObjectImpl.Container implements Security {
	/**
	 * The default value of the '{@link #getUsername() <em>Username</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsername()
	 * @generated
	 * @ordered
	 */
	protected static final String USERNAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUsername() <em>Username</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsername()
	 * @generated
	 * @ordered
	 */
	protected String username = USERNAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getPassword() <em>Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPassword()
	 * @generated
	 * @ordered
	 */
	protected static final String PASSWORD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPassword() <em>Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPassword()
	 * @generated
	 * @ordered
	 */
	protected String password = PASSWORD_EDEFAULT;

	/**
	 * The default value of the '{@link #getKeystorePath() <em>Keystore Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystorePath()
	 * @generated
	 * @ordered
	 */
	protected static final String KEYSTORE_PATH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKeystorePath() <em>Keystore Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystorePath()
	 * @generated
	 * @ordered
	 */
	protected String keystorePath = KEYSTORE_PATH_EDEFAULT;

	/**
	 * The default value of the '{@link #getKeyPath() <em>Key Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeyPath()
	 * @generated
	 * @ordered
	 */
	protected static final String KEY_PATH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKeyPath() <em>Key Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeyPath()
	 * @generated
	 * @ordered
	 */
	protected String keyPath = KEY_PATH_EDEFAULT;

	/**
	 * The default value of the '{@link #getKeystorePassword() <em>Keystore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystorePassword()
	 * @generated
	 * @ordered
	 */
	protected static final String KEYSTORE_PASSWORD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKeystorePassword() <em>Keystore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystorePassword()
	 * @generated
	 * @ordered
	 */
	protected String keystorePassword = KEYSTORE_PASSWORD_EDEFAULT;

	/**
	 * The default value of the '{@link #getTruststorePath() <em>Truststore Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTruststorePath()
	 * @generated
	 * @ordered
	 */
	protected static final String TRUSTSTORE_PATH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTruststorePath() <em>Truststore Path</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTruststorePath()
	 * @generated
	 * @ordered
	 */
	protected String truststorePath = TRUSTSTORE_PATH_EDEFAULT;

	/**
	 * The default value of the '{@link #getTruststorePassword() <em>Truststore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTruststorePassword()
	 * @generated
	 * @ordered
	 */
	protected static final String TRUSTSTORE_PASSWORD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTruststorePassword() <em>Truststore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTruststorePassword()
	 * @generated
	 * @ordered
	 */
	protected String truststorePassword = TRUSTSTORE_PASSWORD_EDEFAULT;

	/**
	 * The default value of the '{@link #isUseSSL() <em>Use SSL</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUseSSL()
	 * @generated
	 * @ordered
	 */
	protected static final boolean USE_SSL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isUseSSL() <em>Use SSL</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUseSSL()
	 * @generated
	 * @ordered
	 */
	protected boolean useSSL = USE_SSL_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SecurityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.SECURITY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUsername() {
		return username;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUsername(String newUsername) {
		String oldUsername = username;
		username = newUsername;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__USERNAME, oldUsername, username));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getPassword() {
		return password;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPassword(String newPassword) {
		String oldPassword = password;
		password = newPassword;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__PASSWORD, oldPassword, password));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getKeystorePath() {
		return keystorePath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKeystorePath(String newKeystorePath) {
		String oldKeystorePath = keystorePath;
		keystorePath = newKeystorePath;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__KEYSTORE_PATH, oldKeystorePath, keystorePath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getKeyPath() {
		return keyPath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKeyPath(String newKeyPath) {
		String oldKeyPath = keyPath;
		keyPath = newKeyPath;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__KEY_PATH, oldKeyPath, keyPath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getKeystorePassword() {
		return keystorePassword;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKeystorePassword(String newKeystorePassword) {
		String oldKeystorePassword = keystorePassword;
		keystorePassword = newKeystorePassword;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__KEYSTORE_PASSWORD, oldKeystorePassword, keystorePassword));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTruststorePath() {
		return truststorePath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTruststorePath(String newTruststorePath) {
		String oldTruststorePath = truststorePath;
		truststorePath = newTruststorePath;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PATH, oldTruststorePath, truststorePath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTruststorePassword() {
		return truststorePassword;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTruststorePassword(String newTruststorePassword) {
		String oldTruststorePassword = truststorePassword;
		truststorePassword = newTruststorePassword;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PASSWORD, oldTruststorePassword, truststorePassword));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isUseSSL() {
		return useSSL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUseSSL(boolean newUseSSL) {
		boolean oldUseSSL = useSSL;
		useSSL = newUseSSL;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.SECURITY__USE_SSL, oldUseSSL, useSSL));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.SECURITY__USERNAME:
				return getUsername();
			case NGSIProtocolsPackage.SECURITY__PASSWORD:
				return getPassword();
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PATH:
				return getKeystorePath();
			case NGSIProtocolsPackage.SECURITY__KEY_PATH:
				return getKeyPath();
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PASSWORD:
				return getKeystorePassword();
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PATH:
				return getTruststorePath();
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PASSWORD:
				return getTruststorePassword();
			case NGSIProtocolsPackage.SECURITY__USE_SSL:
				return isUseSSL();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.SECURITY__USERNAME:
				setUsername((String)newValue);
				return;
			case NGSIProtocolsPackage.SECURITY__PASSWORD:
				setPassword((String)newValue);
				return;
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PATH:
				setKeystorePath((String)newValue);
				return;
			case NGSIProtocolsPackage.SECURITY__KEY_PATH:
				setKeyPath((String)newValue);
				return;
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PASSWORD:
				setKeystorePassword((String)newValue);
				return;
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PATH:
				setTruststorePath((String)newValue);
				return;
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PASSWORD:
				setTruststorePassword((String)newValue);
				return;
			case NGSIProtocolsPackage.SECURITY__USE_SSL:
				setUseSSL((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.SECURITY__USERNAME:
				setUsername(USERNAME_EDEFAULT);
				return;
			case NGSIProtocolsPackage.SECURITY__PASSWORD:
				setPassword(PASSWORD_EDEFAULT);
				return;
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PATH:
				setKeystorePath(KEYSTORE_PATH_EDEFAULT);
				return;
			case NGSIProtocolsPackage.SECURITY__KEY_PATH:
				setKeyPath(KEY_PATH_EDEFAULT);
				return;
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PASSWORD:
				setKeystorePassword(KEYSTORE_PASSWORD_EDEFAULT);
				return;
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PATH:
				setTruststorePath(TRUSTSTORE_PATH_EDEFAULT);
				return;
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PASSWORD:
				setTruststorePassword(TRUSTSTORE_PASSWORD_EDEFAULT);
				return;
			case NGSIProtocolsPackage.SECURITY__USE_SSL:
				setUseSSL(USE_SSL_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.SECURITY__USERNAME:
				return USERNAME_EDEFAULT == null ? username != null : !USERNAME_EDEFAULT.equals(username);
			case NGSIProtocolsPackage.SECURITY__PASSWORD:
				return PASSWORD_EDEFAULT == null ? password != null : !PASSWORD_EDEFAULT.equals(password);
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PATH:
				return KEYSTORE_PATH_EDEFAULT == null ? keystorePath != null : !KEYSTORE_PATH_EDEFAULT.equals(keystorePath);
			case NGSIProtocolsPackage.SECURITY__KEY_PATH:
				return KEY_PATH_EDEFAULT == null ? keyPath != null : !KEY_PATH_EDEFAULT.equals(keyPath);
			case NGSIProtocolsPackage.SECURITY__KEYSTORE_PASSWORD:
				return KEYSTORE_PASSWORD_EDEFAULT == null ? keystorePassword != null : !KEYSTORE_PASSWORD_EDEFAULT.equals(keystorePassword);
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PATH:
				return TRUSTSTORE_PATH_EDEFAULT == null ? truststorePath != null : !TRUSTSTORE_PATH_EDEFAULT.equals(truststorePath);
			case NGSIProtocolsPackage.SECURITY__TRUSTSTORE_PASSWORD:
				return TRUSTSTORE_PASSWORD_EDEFAULT == null ? truststorePassword != null : !TRUSTSTORE_PASSWORD_EDEFAULT.equals(truststorePassword);
			case NGSIProtocolsPackage.SECURITY__USE_SSL:
				return useSSL != USE_SSL_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (username: ");
		result.append(username);
		result.append(", password: ");
		result.append(password);
		result.append(", keystorePath: ");
		result.append(keystorePath);
		result.append(", keyPath: ");
		result.append(keyPath);
		result.append(", keystorePassword: ");
		result.append(keystorePassword);
		result.append(", truststorePath: ");
		result.append(truststorePath);
		result.append(", truststorePassword: ");
		result.append(truststorePassword);
		result.append(", useSSL: ");
		result.append(useSSL);
		result.append(')');
		return result.toString();
	}

} //SecurityImpl
