/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl;

import org.gecko.emf.ngsi.protocols.HTTPHeader;
import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;
import org.gecko.emf.ngsi.protocols.Security;
import org.gecko.emf.ngsi.protocols.WebSocketConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Web Socket Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl#getUrl <em>Url</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl#getSubprotocol <em>Subprotocol</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl#getPingInterval <em>Ping Interval</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl#getMaxFrameSize <em>Max Frame Size</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl#getHeaders <em>Headers</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.impl.WebSocketConfigurationImpl#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @generated
 */
public class WebSocketConfigurationImpl extends ProtocolConfigurationImpl implements WebSocketConfiguration {
	/**
	 * The default value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected String url = URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getSubprotocol() <em>Subprotocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubprotocol()
	 * @generated
	 * @ordered
	 */
	protected static final String SUBPROTOCOL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSubprotocol() <em>Subprotocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubprotocol()
	 * @generated
	 * @ordered
	 */
	protected String subprotocol = SUBPROTOCOL_EDEFAULT;

	/**
	 * The default value of the '{@link #getPingInterval() <em>Ping Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPingInterval()
	 * @generated
	 * @ordered
	 */
	protected static final int PING_INTERVAL_EDEFAULT = 30000;

	/**
	 * The cached value of the '{@link #getPingInterval() <em>Ping Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPingInterval()
	 * @generated
	 * @ordered
	 */
	protected int pingInterval = PING_INTERVAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaxFrameSize() <em>Max Frame Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxFrameSize()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_FRAME_SIZE_EDEFAULT = 65536;

	/**
	 * The cached value of the '{@link #getMaxFrameSize() <em>Max Frame Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxFrameSize()
	 * @generated
	 * @ordered
	 */
	protected int maxFrameSize = MAX_FRAME_SIZE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getHeaders() <em>Headers</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeaders()
	 * @generated
	 * @ordered
	 */
	protected EList<HTTPHeader> headers;

	/**
	 * The cached value of the '{@link #getSecurity() <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecurity()
	 * @generated
	 * @ordered
	 */
	protected Security security;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WebSocketConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIProtocolsPackage.Literals.WEB_SOCKET_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUrl() {
		return url;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUrl(String newUrl) {
		String oldUrl = url;
		url = newUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__URL, oldUrl, url));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getSubprotocol() {
		return subprotocol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSubprotocol(String newSubprotocol) {
		String oldSubprotocol = subprotocol;
		subprotocol = newSubprotocol;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SUBPROTOCOL, oldSubprotocol, subprotocol));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPingInterval() {
		return pingInterval;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPingInterval(int newPingInterval) {
		int oldPingInterval = pingInterval;
		pingInterval = newPingInterval;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__PING_INTERVAL, oldPingInterval, pingInterval));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getMaxFrameSize() {
		return maxFrameSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMaxFrameSize(int newMaxFrameSize) {
		int oldMaxFrameSize = maxFrameSize;
		maxFrameSize = newMaxFrameSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE, oldMaxFrameSize, maxFrameSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<HTTPHeader> getHeaders() {
		if (headers == null) {
			headers = new EObjectContainmentEList<HTTPHeader>(HTTPHeader.class, this, NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__HEADERS);
		}
		return headers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Security getSecurity() {
		return security;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSecurity(Security newSecurity, NotificationChain msgs) {
		Security oldSecurity = security;
		security = newSecurity;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY, oldSecurity, newSecurity);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSecurity(Security newSecurity) {
		if (newSecurity != security) {
			NotificationChain msgs = null;
			if (security != null)
				msgs = ((InternalEObject)security).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY, null, msgs);
			if (newSecurity != null)
				msgs = ((InternalEObject)newSecurity).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY, null, msgs);
			msgs = basicSetSecurity(newSecurity, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY, newSecurity, newSecurity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__HEADERS:
				return ((InternalEList<?>)getHeaders()).basicRemove(otherEnd, msgs);
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY:
				return basicSetSecurity(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__URL:
				return getUrl();
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SUBPROTOCOL:
				return getSubprotocol();
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__PING_INTERVAL:
				return getPingInterval();
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE:
				return getMaxFrameSize();
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__HEADERS:
				return getHeaders();
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY:
				return getSecurity();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__URL:
				setUrl((String)newValue);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SUBPROTOCOL:
				setSubprotocol((String)newValue);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__PING_INTERVAL:
				setPingInterval((Integer)newValue);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE:
				setMaxFrameSize((Integer)newValue);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__HEADERS:
				getHeaders().clear();
				getHeaders().addAll((Collection<? extends HTTPHeader>)newValue);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY:
				setSecurity((Security)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__URL:
				setUrl(URL_EDEFAULT);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SUBPROTOCOL:
				setSubprotocol(SUBPROTOCOL_EDEFAULT);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__PING_INTERVAL:
				setPingInterval(PING_INTERVAL_EDEFAULT);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE:
				setMaxFrameSize(MAX_FRAME_SIZE_EDEFAULT);
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__HEADERS:
				getHeaders().clear();
				return;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY:
				setSecurity((Security)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__URL:
				return URL_EDEFAULT == null ? url != null : !URL_EDEFAULT.equals(url);
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SUBPROTOCOL:
				return SUBPROTOCOL_EDEFAULT == null ? subprotocol != null : !SUBPROTOCOL_EDEFAULT.equals(subprotocol);
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__PING_INTERVAL:
				return pingInterval != PING_INTERVAL_EDEFAULT;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__MAX_FRAME_SIZE:
				return maxFrameSize != MAX_FRAME_SIZE_EDEFAULT;
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__HEADERS:
				return headers != null && !headers.isEmpty();
			case NGSIProtocolsPackage.WEB_SOCKET_CONFIGURATION__SECURITY:
				return security != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (url: ");
		result.append(url);
		result.append(", subprotocol: ");
		result.append(subprotocol);
		result.append(", pingInterval: ");
		result.append(pingInterval);
		result.append(", maxFrameSize: ");
		result.append(maxFrameSize);
		result.append(')');
		return result.toString();
	}

} //WebSocketConfigurationImpl
