/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.gecko.emf.ngsi.ProtocolConfiguration;

import org.gecko.emf.ngsi.protocols.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage
 * @generated
 */
public class NGSIProtocolsAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static NGSIProtocolsPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSIProtocolsAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = NGSIProtocolsPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NGSIProtocolsSwitch<Adapter> modelSwitch =
		new NGSIProtocolsSwitch<Adapter>() {
			@Override
			public Adapter caseHTTPConfiguration(HTTPConfiguration object) {
				return createHTTPConfigurationAdapter();
			}
			@Override
			public Adapter caseMQTTConfiguration(MQTTConfiguration object) {
				return createMQTTConfigurationAdapter();
			}
			@Override
			public Adapter caseWebSocketConfiguration(WebSocketConfiguration object) {
				return createWebSocketConfigurationAdapter();
			}
			@Override
			public Adapter caseKafkaConfiguration(KafkaConfiguration object) {
				return createKafkaConfigurationAdapter();
			}
			@Override
			public Adapter caseAMQPConfiguration(AMQPConfiguration object) {
				return createAMQPConfigurationAdapter();
			}
			@Override
			public Adapter caseSecurity(Security object) {
				return createSecurityAdapter();
			}
			@Override
			public Adapter caseHTTPSecurity(HTTPSecurity object) {
				return createHTTPSecurityAdapter();
			}
			@Override
			public Adapter caseMQTTSecurity(MQTTSecurity object) {
				return createMQTTSecurityAdapter();
			}
			@Override
			public Adapter caseKafkaSecurity(KafkaSecurity object) {
				return createKafkaSecurityAdapter();
			}
			@Override
			public Adapter caseHTTPHeader(HTTPHeader object) {
				return createHTTPHeaderAdapter();
			}
			@Override
			public Adapter caseKafkaProperty(KafkaProperty object) {
				return createKafkaPropertyAdapter();
			}
			@Override
			public Adapter caseProtocolConfiguration(ProtocolConfiguration object) {
				return createProtocolConfigurationAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration <em>HTTP Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.HTTPConfiguration
	 * @generated
	 */
	public Adapter createHTTPConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration <em>MQTT Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.MQTTConfiguration
	 * @generated
	 */
	public Adapter createMQTTConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.WebSocketConfiguration <em>Web Socket Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.WebSocketConfiguration
	 * @generated
	 */
	public Adapter createWebSocketConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration <em>Kafka Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.KafkaConfiguration
	 * @generated
	 */
	public Adapter createKafkaConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration <em>AMQP Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.AMQPConfiguration
	 * @generated
	 */
	public Adapter createAMQPConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.Security <em>Security</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.Security
	 * @generated
	 */
	public Adapter createSecurityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity <em>HTTP Security</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.HTTPSecurity
	 * @generated
	 */
	public Adapter createHTTPSecurityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.MQTTSecurity <em>MQTT Security</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.MQTTSecurity
	 * @generated
	 */
	public Adapter createMQTTSecurityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity <em>Kafka Security</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurity
	 * @generated
	 */
	public Adapter createKafkaSecurityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.HTTPHeader <em>HTTP Header</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.HTTPHeader
	 * @generated
	 */
	public Adapter createHTTPHeaderAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.protocols.KafkaProperty <em>Kafka Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.protocols.KafkaProperty
	 * @generated
	 */
	public Adapter createKafkaPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.ProtocolConfiguration <em>Protocol Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.ProtocolConfiguration
	 * @generated
	 */
	public Adapter createProtocolConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //NGSIProtocolsAdapterFactory
