/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.gecko.emf.ngsi.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.gecko.emf.ngsi.NGSIPackage
 * @generated
 */
public class NGSIAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static NGSIPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSIAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = NGSIPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NGSISwitch<Adapter> modelSwitch =
		new NGSISwitch<Adapter>() {
			@Override
			public Adapter caseNGSIContainer(NGSIContainer object) {
				return createNGSIContainerAdapter();
			}
			@Override
			public Adapter caseNGSIEntity(NGSIEntity object) {
				return createNGSIEntityAdapter();
			}
			@Override
			public Adapter caseEntityMappingConfiguration(EntityMappingConfiguration object) {
				return createEntityMappingConfigurationAdapter();
			}
			@Override
			public Adapter casePropertyMapping(PropertyMapping object) {
				return createPropertyMappingAdapter();
			}
			@Override
			public Adapter caseRelationshipMapping(RelationshipMapping object) {
				return createRelationshipMappingAdapter();
			}
			@Override
			public Adapter caseNGSIProperty(NGSIProperty object) {
				return createNGSIPropertyAdapter();
			}
			@Override
			public Adapter caseNGSIRelationship(NGSIRelationship object) {
				return createNGSIRelationshipAdapter();
			}
			@Override
			public Adapter caseNGSIContext(NGSIContext object) {
				return createNGSIContextAdapter();
			}
			@Override
			public Adapter caseContextMapping(ContextMapping object) {
				return createContextMappingAdapter();
			}
			@Override
			public Adapter caseNGSISubscription(NGSISubscription object) {
				return createNGSISubscriptionAdapter();
			}
			@Override
			public Adapter caseEntityInfo(EntityInfo object) {
				return createEntityInfoAdapter();
			}
			@Override
			public Adapter caseNotificationParams(NotificationParams object) {
				return createNotificationParamsAdapter();
			}
			@Override
			public Adapter caseSubscriptionCondition(SubscriptionCondition object) {
				return createSubscriptionConditionAdapter();
			}
			@Override
			public Adapter caseProtocolConfiguration(ProtocolConfiguration object) {
				return createProtocolConfigurationAdapter();
			}
			@Override
			public Adapter caseValueConverter(ValueConverter object) {
				return createValueConverterAdapter();
			}
			@Override
			public Adapter caseDateTimeConverter(DateTimeConverter object) {
				return createDateTimeConverterAdapter();
			}
			@Override
			public Adapter caseEnumConverter(EnumConverter object) {
				return createEnumConverterAdapter();
			}
			@Override
			public Adapter caseCustomConverter(CustomConverter object) {
				return createCustomConverterAdapter();
			}
			@Override
			public Adapter caseNGSIValue(NGSIValue object) {
				return createNGSIValueAdapter();
			}
			@Override
			public Adapter caseNGSIStringValue(NGSIStringValue object) {
				return createNGSIStringValueAdapter();
			}
			@Override
			public Adapter caseNGSINumberValue(NGSINumberValue object) {
				return createNGSINumberValueAdapter();
			}
			@Override
			public Adapter caseNGSIBooleanValue(NGSIBooleanValue object) {
				return createNGSIBooleanValueAdapter();
			}
			@Override
			public Adapter caseNGSIObjectValue(NGSIObjectValue object) {
				return createNGSIObjectValueAdapter();
			}
			@Override
			public Adapter caseNGSIArrayValue(NGSIArrayValue object) {
				return createNGSIArrayValueAdapter();
			}
			@Override
			public Adapter caseNGSIGeoValue(NGSIGeoValue object) {
				return createNGSIGeoValueAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIContainer <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIContainer
	 * @generated
	 */
	public Adapter createNGSIContainerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIEntity
	 * @generated
	 */
	public Adapter createNGSIEntityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.EntityMappingConfiguration <em>Entity Mapping Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.EntityMappingConfiguration
	 * @generated
	 */
	public Adapter createEntityMappingConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.PropertyMapping <em>Property Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.PropertyMapping
	 * @generated
	 */
	public Adapter createPropertyMappingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.RelationshipMapping <em>Relationship Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.RelationshipMapping
	 * @generated
	 */
	public Adapter createRelationshipMappingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIProperty <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIProperty
	 * @generated
	 */
	public Adapter createNGSIPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIRelationship <em>Relationship</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIRelationship
	 * @generated
	 */
	public Adapter createNGSIRelationshipAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIContext <em>Context</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIContext
	 * @generated
	 */
	public Adapter createNGSIContextAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.ContextMapping <em>Context Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.ContextMapping
	 * @generated
	 */
	public Adapter createContextMappingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSISubscription <em>Subscription</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSISubscription
	 * @generated
	 */
	public Adapter createNGSISubscriptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.EntityInfo <em>Entity Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.EntityInfo
	 * @generated
	 */
	public Adapter createEntityInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NotificationParams <em>Notification Params</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NotificationParams
	 * @generated
	 */
	public Adapter createNotificationParamsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.SubscriptionCondition <em>Subscription Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.SubscriptionCondition
	 * @generated
	 */
	public Adapter createSubscriptionConditionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.ProtocolConfiguration <em>Protocol Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.ProtocolConfiguration
	 * @generated
	 */
	public Adapter createProtocolConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.ValueConverter <em>Value Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.ValueConverter
	 * @generated
	 */
	public Adapter createValueConverterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.DateTimeConverter <em>Date Time Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.DateTimeConverter
	 * @generated
	 */
	public Adapter createDateTimeConverterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.EnumConverter <em>Enum Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.EnumConverter
	 * @generated
	 */
	public Adapter createEnumConverterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.CustomConverter <em>Custom Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.CustomConverter
	 * @generated
	 */
	public Adapter createCustomConverterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIValue
	 * @generated
	 */
	public Adapter createNGSIValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIStringValue <em>String Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIStringValue
	 * @generated
	 */
	public Adapter createNGSIStringValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSINumberValue <em>Number Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSINumberValue
	 * @generated
	 */
	public Adapter createNGSINumberValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIBooleanValue <em>Boolean Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIBooleanValue
	 * @generated
	 */
	public Adapter createNGSIBooleanValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIObjectValue <em>Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIObjectValue
	 * @generated
	 */
	public Adapter createNGSIObjectValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIArrayValue <em>Array Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIArrayValue
	 * @generated
	 */
	public Adapter createNGSIArrayValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.gecko.emf.ngsi.NGSIGeoValue <em>Geo Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.gecko.emf.ngsi.NGSIGeoValue
	 * @generated
	 */
	public Adapter createNGSIGeoValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //NGSIAdapterFactory
