/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.gecko.emf.ngsi.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.gecko.emf.ngsi.NGSIPackage
 * @generated
 */
public class NGSISwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static NGSIPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSISwitch() {
		if (modelPackage == null) {
			modelPackage = NGSIPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case NGSIPackage.NGSI_CONTAINER: {
				NGSIContainer ngsiContainer = (NGSIContainer)theEObject;
				T result = caseNGSIContainer(ngsiContainer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_ENTITY: {
				NGSIEntity ngsiEntity = (NGSIEntity)theEObject;
				T result = caseNGSIEntity(ngsiEntity);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION: {
				EntityMappingConfiguration entityMappingConfiguration = (EntityMappingConfiguration)theEObject;
				T result = caseEntityMappingConfiguration(entityMappingConfiguration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.PROPERTY_MAPPING: {
				PropertyMapping propertyMapping = (PropertyMapping)theEObject;
				T result = casePropertyMapping(propertyMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.RELATIONSHIP_MAPPING: {
				RelationshipMapping relationshipMapping = (RelationshipMapping)theEObject;
				T result = caseRelationshipMapping(relationshipMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_PROPERTY: {
				NGSIProperty ngsiProperty = (NGSIProperty)theEObject;
				T result = caseNGSIProperty(ngsiProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_RELATIONSHIP: {
				NGSIRelationship ngsiRelationship = (NGSIRelationship)theEObject;
				T result = caseNGSIRelationship(ngsiRelationship);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_CONTEXT: {
				NGSIContext ngsiContext = (NGSIContext)theEObject;
				T result = caseNGSIContext(ngsiContext);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.CONTEXT_MAPPING: {
				ContextMapping contextMapping = (ContextMapping)theEObject;
				T result = caseContextMapping(contextMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_SUBSCRIPTION: {
				NGSISubscription ngsiSubscription = (NGSISubscription)theEObject;
				T result = caseNGSISubscription(ngsiSubscription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.ENTITY_INFO: {
				EntityInfo entityInfo = (EntityInfo)theEObject;
				T result = caseEntityInfo(entityInfo);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NOTIFICATION_PARAMS: {
				NotificationParams notificationParams = (NotificationParams)theEObject;
				T result = caseNotificationParams(notificationParams);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.SUBSCRIPTION_CONDITION: {
				SubscriptionCondition subscriptionCondition = (SubscriptionCondition)theEObject;
				T result = caseSubscriptionCondition(subscriptionCondition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.PROTOCOL_CONFIGURATION: {
				ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)theEObject;
				T result = caseProtocolConfiguration(protocolConfiguration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.VALUE_CONVERTER: {
				ValueConverter valueConverter = (ValueConverter)theEObject;
				T result = caseValueConverter(valueConverter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.DATE_TIME_CONVERTER: {
				DateTimeConverter dateTimeConverter = (DateTimeConverter)theEObject;
				T result = caseDateTimeConverter(dateTimeConverter);
				if (result == null) result = caseValueConverter(dateTimeConverter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.ENUM_CONVERTER: {
				EnumConverter enumConverter = (EnumConverter)theEObject;
				T result = caseEnumConverter(enumConverter);
				if (result == null) result = caseValueConverter(enumConverter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.CUSTOM_CONVERTER: {
				CustomConverter customConverter = (CustomConverter)theEObject;
				T result = caseCustomConverter(customConverter);
				if (result == null) result = caseValueConverter(customConverter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_VALUE: {
				NGSIValue ngsiValue = (NGSIValue)theEObject;
				T result = caseNGSIValue(ngsiValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_STRING_VALUE: {
				NGSIStringValue ngsiStringValue = (NGSIStringValue)theEObject;
				T result = caseNGSIStringValue(ngsiStringValue);
				if (result == null) result = caseNGSIValue(ngsiStringValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_NUMBER_VALUE: {
				NGSINumberValue ngsiNumberValue = (NGSINumberValue)theEObject;
				T result = caseNGSINumberValue(ngsiNumberValue);
				if (result == null) result = caseNGSIValue(ngsiNumberValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_BOOLEAN_VALUE: {
				NGSIBooleanValue ngsiBooleanValue = (NGSIBooleanValue)theEObject;
				T result = caseNGSIBooleanValue(ngsiBooleanValue);
				if (result == null) result = caseNGSIValue(ngsiBooleanValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_OBJECT_VALUE: {
				NGSIObjectValue ngsiObjectValue = (NGSIObjectValue)theEObject;
				T result = caseNGSIObjectValue(ngsiObjectValue);
				if (result == null) result = caseNGSIValue(ngsiObjectValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_ARRAY_VALUE: {
				NGSIArrayValue ngsiArrayValue = (NGSIArrayValue)theEObject;
				T result = caseNGSIArrayValue(ngsiArrayValue);
				if (result == null) result = caseNGSIValue(ngsiArrayValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case NGSIPackage.NGSI_GEO_VALUE: {
				NGSIGeoValue ngsiGeoValue = (NGSIGeoValue)theEObject;
				T result = caseNGSIGeoValue(ngsiGeoValue);
				if (result == null) result = caseNGSIValue(ngsiGeoValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIContainer(NGSIContainer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIEntity(NGSIEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity Mapping Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity Mapping Configuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntityMappingConfiguration(EntityMappingConfiguration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertyMapping(PropertyMapping object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Relationship Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Relationship Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRelationshipMapping(RelationshipMapping object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIProperty(NGSIProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Relationship</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIRelationship(NGSIRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIContext(NGSIContext object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContextMapping(ContextMapping object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Subscription</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Subscription</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSISubscription(NGSISubscription object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity Info</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity Info</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntityInfo(EntityInfo object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Notification Params</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Notification Params</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNotificationParams(NotificationParams object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Subscription Condition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Subscription Condition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSubscriptionCondition(SubscriptionCondition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Protocol Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Protocol Configuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProtocolConfiguration(ProtocolConfiguration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Value Converter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Value Converter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseValueConverter(ValueConverter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Date Time Converter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Date Time Converter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDateTimeConverter(DateTimeConverter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enum Converter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enum Converter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEnumConverter(EnumConverter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Custom Converter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Custom Converter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCustomConverter(CustomConverter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIValue(NGSIValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIStringValue(NGSIStringValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Number Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Number Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSINumberValue(NGSINumberValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Boolean Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Boolean Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIBooleanValue(NGSIBooleanValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Object Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Object Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIObjectValue(NGSIObjectValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIArrayValue(NGSIArrayValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Geo Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Geo Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNGSIGeoValue(NGSIGeoValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //NGSISwitch
