/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semex;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.emf.semex.SemExFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel basePackage='org.gecko.emf' oSGiCompatible='true' complianceLevel='17.0' fileExtensions='semex' resource='XMI' copyrightText='Copyright (c) 2012 - 2024 Data In Motion and others.\nAll rights reserved. \n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motion - initial API and implementation'"
 * @generated
 */
@ProviderType
@EPackage(uri = SemExPackage.eNS_URI, genModel = "/model/semex.genmodel", genModelSourceLocations = {"model/semex.genmodel","org.gecko.emf.semantic.demo.model/model/semex.genmodel"}, ecore="/model/semex.ecore", ecoreSourceLocations="/model/semex.ecore")
public interface SemExPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "semex";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "https://geckoprojects.org/semex/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "semex";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SemExPackage eINSTANCE = org.gecko.emf.semex.impl.SemExPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.emf.semex.impl.SensorAImpl <em>Sensor A</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.semex.impl.SensorAImpl
	 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getSensorA()
	 * @generated
	 */
	int SENSOR_A = 0;

	/**
	 * The feature id for the '<em><b>Id A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_A__ID_A = 0;

	/**
	 * The feature id for the '<em><b>Name A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_A__NAME_A = 1;

	/**
	 * The feature id for the '<em><b>Value A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_A__VALUE_A = 2;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_A__UNIT = 3;

	/**
	 * The feature id for the '<em><b>Geo</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_A__GEO = 4;

	/**
	 * The number of structural features of the '<em>Sensor A</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_A_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Sensor A</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_A_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.semex.impl.SensorBImpl <em>Sensor B</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.semex.impl.SensorBImpl
	 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getSensorB()
	 * @generated
	 */
	int SENSOR_B = 1;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_B__UUID = 0;

	/**
	 * The feature id for the '<em><b>Sensor Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_B__SENSOR_ID = 1;

	/**
	 * The feature id for the '<em><b>Value B</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_B__VALUE_B = 2;

	/**
	 * The feature id for the '<em><b>Latitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_B__LATITUDE = 3;

	/**
	 * The feature id for the '<em><b>Longitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_B__LONGITUDE = 4;

	/**
	 * The number of structural features of the '<em>Sensor B</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_B_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Sensor B</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_B_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.semex.impl.TreeImpl <em>Tree</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.semex.impl.TreeImpl
	 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getTree()
	 * @generated
	 */
	int TREE = 2;

	/**
	 * The feature id for the '<em><b>Id Tree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TREE__ID_TREE = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TREE__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TREE__LOCATION = 2;

	/**
	 * The number of structural features of the '<em>Tree</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TREE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Tree</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TREE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.semex.impl.LocationImpl <em>Location</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.semex.impl.LocationImpl
	 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getLocation()
	 * @generated
	 */
	int LOCATION = 3;

	/**
	 * The feature id for the '<em><b>Latitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION__LATITUDE = 0;

	/**
	 * The feature id for the '<em><b>Longitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION__LONGITUDE = 1;

	/**
	 * The number of structural features of the '<em>Location</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Location</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link org.gecko.emf.semex.SensorA <em>Sensor A</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sensor A</em>'.
	 * @see org.gecko.emf.semex.SensorA
	 * @generated
	 */
	EClass getSensorA();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorA#getIdA <em>Id A</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id A</em>'.
	 * @see org.gecko.emf.semex.SensorA#getIdA()
	 * @see #getSensorA()
	 * @generated
	 */
	EAttribute getSensorA_IdA();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorA#getNameA <em>Name A</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name A</em>'.
	 * @see org.gecko.emf.semex.SensorA#getNameA()
	 * @see #getSensorA()
	 * @generated
	 */
	EAttribute getSensorA_NameA();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorA#getValueA <em>Value A</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value A</em>'.
	 * @see org.gecko.emf.semex.SensorA#getValueA()
	 * @see #getSensorA()
	 * @generated
	 */
	EAttribute getSensorA_ValueA();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorA#getUnit <em>Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unit</em>'.
	 * @see org.gecko.emf.semex.SensorA#getUnit()
	 * @see #getSensorA()
	 * @generated
	 */
	EAttribute getSensorA_Unit();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.semex.SensorA#getGeo <em>Geo</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Geo</em>'.
	 * @see org.gecko.emf.semex.SensorA#getGeo()
	 * @see #getSensorA()
	 * @generated
	 */
	EReference getSensorA_Geo();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.semex.SensorB <em>Sensor B</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sensor B</em>'.
	 * @see org.gecko.emf.semex.SensorB
	 * @generated
	 */
	EClass getSensorB();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorB#getUuid <em>Uuid</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuid</em>'.
	 * @see org.gecko.emf.semex.SensorB#getUuid()
	 * @see #getSensorB()
	 * @generated
	 */
	EAttribute getSensorB_Uuid();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorB#getSensorId <em>Sensor Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sensor Id</em>'.
	 * @see org.gecko.emf.semex.SensorB#getSensorId()
	 * @see #getSensorB()
	 * @generated
	 */
	EAttribute getSensorB_SensorId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorB#getValueB <em>Value B</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value B</em>'.
	 * @see org.gecko.emf.semex.SensorB#getValueB()
	 * @see #getSensorB()
	 * @generated
	 */
	EAttribute getSensorB_ValueB();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorB#getLatitude <em>Latitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Latitude</em>'.
	 * @see org.gecko.emf.semex.SensorB#getLatitude()
	 * @see #getSensorB()
	 * @generated
	 */
	EAttribute getSensorB_Latitude();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.SensorB#getLongitude <em>Longitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Longitude</em>'.
	 * @see org.gecko.emf.semex.SensorB#getLongitude()
	 * @see #getSensorB()
	 * @generated
	 */
	EAttribute getSensorB_Longitude();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.semex.Tree <em>Tree</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tree</em>'.
	 * @see org.gecko.emf.semex.Tree
	 * @generated
	 */
	EClass getTree();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.Tree#getIdTree <em>Id Tree</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id Tree</em>'.
	 * @see org.gecko.emf.semex.Tree#getIdTree()
	 * @see #getTree()
	 * @generated
	 */
	EAttribute getTree_IdTree();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.Tree#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.emf.semex.Tree#getType()
	 * @see #getTree()
	 * @generated
	 */
	EAttribute getTree_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.Tree#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Location</em>'.
	 * @see org.gecko.emf.semex.Tree#getLocation()
	 * @see #getTree()
	 * @generated
	 */
	EAttribute getTree_Location();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.semex.Location <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Location</em>'.
	 * @see org.gecko.emf.semex.Location
	 * @generated
	 */
	EClass getLocation();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.Location#getLatitude <em>Latitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Latitude</em>'.
	 * @see org.gecko.emf.semex.Location#getLatitude()
	 * @see #getLocation()
	 * @generated
	 */
	EAttribute getLocation_Latitude();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.semex.Location#getLongitude <em>Longitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Longitude</em>'.
	 * @see org.gecko.emf.semex.Location#getLongitude()
	 * @see #getLocation()
	 * @generated
	 */
	EAttribute getLocation_Longitude();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SemExFactory getSemExFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.emf.semex.impl.SensorAImpl <em>Sensor A</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.semex.impl.SensorAImpl
		 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getSensorA()
		 * @generated
		 */
		EClass SENSOR_A = eINSTANCE.getSensorA();

		/**
		 * The meta object literal for the '<em><b>Id A</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_A__ID_A = eINSTANCE.getSensorA_IdA();

		/**
		 * The meta object literal for the '<em><b>Name A</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_A__NAME_A = eINSTANCE.getSensorA_NameA();

		/**
		 * The meta object literal for the '<em><b>Value A</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_A__VALUE_A = eINSTANCE.getSensorA_ValueA();

		/**
		 * The meta object literal for the '<em><b>Unit</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_A__UNIT = eINSTANCE.getSensorA_Unit();

		/**
		 * The meta object literal for the '<em><b>Geo</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SENSOR_A__GEO = eINSTANCE.getSensorA_Geo();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.semex.impl.SensorBImpl <em>Sensor B</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.semex.impl.SensorBImpl
		 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getSensorB()
		 * @generated
		 */
		EClass SENSOR_B = eINSTANCE.getSensorB();

		/**
		 * The meta object literal for the '<em><b>Uuid</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_B__UUID = eINSTANCE.getSensorB_Uuid();

		/**
		 * The meta object literal for the '<em><b>Sensor Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_B__SENSOR_ID = eINSTANCE.getSensorB_SensorId();

		/**
		 * The meta object literal for the '<em><b>Value B</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_B__VALUE_B = eINSTANCE.getSensorB_ValueB();

		/**
		 * The meta object literal for the '<em><b>Latitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_B__LATITUDE = eINSTANCE.getSensorB_Latitude();

		/**
		 * The meta object literal for the '<em><b>Longitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SENSOR_B__LONGITUDE = eINSTANCE.getSensorB_Longitude();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.semex.impl.TreeImpl <em>Tree</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.semex.impl.TreeImpl
		 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getTree()
		 * @generated
		 */
		EClass TREE = eINSTANCE.getTree();

		/**
		 * The meta object literal for the '<em><b>Id Tree</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TREE__ID_TREE = eINSTANCE.getTree_IdTree();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TREE__TYPE = eINSTANCE.getTree_Type();

		/**
		 * The meta object literal for the '<em><b>Location</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TREE__LOCATION = eINSTANCE.getTree_Location();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.semex.impl.LocationImpl <em>Location</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.semex.impl.LocationImpl
		 * @see org.gecko.emf.semex.impl.SemExPackageImpl#getLocation()
		 * @generated
		 */
		EClass LOCATION = eINSTANCE.getLocation();

		/**
		 * The meta object literal for the '<em><b>Latitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOCATION__LATITUDE = eINSTANCE.getLocation_Latitude();

		/**
		 * The meta object literal for the '<em><b>Longitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOCATION__LONGITUDE = eINSTANCE.getLocation_Longitude();

	}

} //SemExPackage
