/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semex;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Sensor A</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semex.SensorA#getIdA <em>Id A</em>}</li>
 *   <li>{@link org.gecko.emf.semex.SensorA#getNameA <em>Name A</em>}</li>
 *   <li>{@link org.gecko.emf.semex.SensorA#getValueA <em>Value A</em>}</li>
 *   <li>{@link org.gecko.emf.semex.SensorA#getUnit <em>Unit</em>}</li>
 *   <li>{@link org.gecko.emf.semex.SensorA#getGeo <em>Geo</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.semex.SemExPackage#getSensorA()
 * @model
 * @generated
 */
@ProviderType
public interface SensorA extends EObject {
	/**
	 * Returns the value of the '<em><b>Id A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id A</em>' attribute.
	 * @see #setIdA(String)
	 * @see org.gecko.emf.semex.SemExPackage#getSensorA_IdA()
	 * @model id="true"
	 * @generated
	 */
	String getIdA();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semex.SensorA#getIdA <em>Id A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id A</em>' attribute.
	 * @see #getIdA()
	 * @generated
	 */
	void setIdA(String value);

	/**
	 * Returns the value of the '<em><b>Name A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name A</em>' attribute.
	 * @see #setNameA(String)
	 * @see org.gecko.emf.semex.SemExPackage#getSensorA_NameA()
	 * @model
	 * @generated
	 */
	String getNameA();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semex.SensorA#getNameA <em>Name A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name A</em>' attribute.
	 * @see #getNameA()
	 * @generated
	 */
	void setNameA(String value);

	/**
	 * Returns the value of the '<em><b>Value A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value A</em>' attribute.
	 * @see #setValueA(int)
	 * @see org.gecko.emf.semex.SemExPackage#getSensorA_ValueA()
	 * @model
	 * @generated
	 */
	int getValueA();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semex.SensorA#getValueA <em>Value A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value A</em>' attribute.
	 * @see #getValueA()
	 * @generated
	 */
	void setValueA(int value);

	/**
	 * Returns the value of the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Unit</em>' attribute.
	 * @see #setUnit(String)
	 * @see org.gecko.emf.semex.SemExPackage#getSensorA_Unit()
	 * @model
	 * @generated
	 */
	String getUnit();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semex.SensorA#getUnit <em>Unit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unit</em>' attribute.
	 * @see #getUnit()
	 * @generated
	 */
	void setUnit(String value);

	/**
	 * Returns the value of the '<em><b>Geo</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Geo</em>' reference.
	 * @see #setGeo(Location)
	 * @see org.gecko.emf.semex.SemExPackage#getSensorA_Geo()
	 * @model
	 * @generated
	 */
	Location getGeo();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semex.SensorA#getGeo <em>Geo</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Geo</em>' reference.
	 * @see #getGeo()
	 * @generated
	 */
	void setGeo(Location value);

} // SensorA
