/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semex.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.emf.semex.Location;
import org.gecko.emf.semex.SemExPackage;
import org.gecko.emf.semex.SensorA;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Sensor A</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semex.impl.SensorAImpl#getIdA <em>Id A</em>}</li>
 *   <li>{@link org.gecko.emf.semex.impl.SensorAImpl#getNameA <em>Name A</em>}</li>
 *   <li>{@link org.gecko.emf.semex.impl.SensorAImpl#getValueA <em>Value A</em>}</li>
 *   <li>{@link org.gecko.emf.semex.impl.SensorAImpl#getUnit <em>Unit</em>}</li>
 *   <li>{@link org.gecko.emf.semex.impl.SensorAImpl#getGeo <em>Geo</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SensorAImpl extends MinimalEObjectImpl.Container implements SensorA {
	/**
	 * The default value of the '{@link #getIdA() <em>Id A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdA()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_A_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIdA() <em>Id A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdA()
	 * @generated
	 * @ordered
	 */
	protected String idA = ID_A_EDEFAULT;

	/**
	 * The default value of the '{@link #getNameA() <em>Name A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNameA()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_A_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getNameA() <em>Name A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNameA()
	 * @generated
	 * @ordered
	 */
	protected String nameA = NAME_A_EDEFAULT;

	/**
	 * The default value of the '{@link #getValueA() <em>Value A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueA()
	 * @generated
	 * @ordered
	 */
	protected static final int VALUE_A_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getValueA() <em>Value A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueA()
	 * @generated
	 * @ordered
	 */
	protected int valueA = VALUE_A_EDEFAULT;

	/**
	 * The default value of the '{@link #getUnit() <em>Unit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnit()
	 * @generated
	 * @ordered
	 */
	protected static final String UNIT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUnit() <em>Unit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnit()
	 * @generated
	 * @ordered
	 */
	protected String unit = UNIT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getGeo() <em>Geo</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGeo()
	 * @generated
	 * @ordered
	 */
	protected Location geo;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SensorAImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SemExPackage.Literals.SENSOR_A;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getIdA() {
		return idA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIdA(String newIdA) {
		String oldIdA = idA;
		idA = newIdA;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemExPackage.SENSOR_A__ID_A, oldIdA, idA));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getNameA() {
		return nameA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNameA(String newNameA) {
		String oldNameA = nameA;
		nameA = newNameA;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemExPackage.SENSOR_A__NAME_A, oldNameA, nameA));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValueA() {
		return valueA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setValueA(int newValueA) {
		int oldValueA = valueA;
		valueA = newValueA;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemExPackage.SENSOR_A__VALUE_A, oldValueA, valueA));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUnit() {
		return unit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUnit(String newUnit) {
		String oldUnit = unit;
		unit = newUnit;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemExPackage.SENSOR_A__UNIT, oldUnit, unit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Location getGeo() {
		if (geo != null && geo.eIsProxy()) {
			InternalEObject oldGeo = (InternalEObject)geo;
			geo = (Location)eResolveProxy(oldGeo);
			if (geo != oldGeo) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SemExPackage.SENSOR_A__GEO, oldGeo, geo));
			}
		}
		return geo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Location basicGetGeo() {
		return geo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGeo(Location newGeo) {
		Location oldGeo = geo;
		geo = newGeo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemExPackage.SENSOR_A__GEO, oldGeo, geo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SemExPackage.SENSOR_A__ID_A:
				return getIdA();
			case SemExPackage.SENSOR_A__NAME_A:
				return getNameA();
			case SemExPackage.SENSOR_A__VALUE_A:
				return getValueA();
			case SemExPackage.SENSOR_A__UNIT:
				return getUnit();
			case SemExPackage.SENSOR_A__GEO:
				if (resolve) return getGeo();
				return basicGetGeo();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SemExPackage.SENSOR_A__ID_A:
				setIdA((String)newValue);
				return;
			case SemExPackage.SENSOR_A__NAME_A:
				setNameA((String)newValue);
				return;
			case SemExPackage.SENSOR_A__VALUE_A:
				setValueA((Integer)newValue);
				return;
			case SemExPackage.SENSOR_A__UNIT:
				setUnit((String)newValue);
				return;
			case SemExPackage.SENSOR_A__GEO:
				setGeo((Location)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SemExPackage.SENSOR_A__ID_A:
				setIdA(ID_A_EDEFAULT);
				return;
			case SemExPackage.SENSOR_A__NAME_A:
				setNameA(NAME_A_EDEFAULT);
				return;
			case SemExPackage.SENSOR_A__VALUE_A:
				setValueA(VALUE_A_EDEFAULT);
				return;
			case SemExPackage.SENSOR_A__UNIT:
				setUnit(UNIT_EDEFAULT);
				return;
			case SemExPackage.SENSOR_A__GEO:
				setGeo((Location)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SemExPackage.SENSOR_A__ID_A:
				return ID_A_EDEFAULT == null ? idA != null : !ID_A_EDEFAULT.equals(idA);
			case SemExPackage.SENSOR_A__NAME_A:
				return NAME_A_EDEFAULT == null ? nameA != null : !NAME_A_EDEFAULT.equals(nameA);
			case SemExPackage.SENSOR_A__VALUE_A:
				return valueA != VALUE_A_EDEFAULT;
			case SemExPackage.SENSOR_A__UNIT:
				return UNIT_EDEFAULT == null ? unit != null : !UNIT_EDEFAULT.equals(unit);
			case SemExPackage.SENSOR_A__GEO:
				return geo != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (idA: ");
		result.append(idA);
		result.append(", nameA: ");
		result.append(nameA);
		result.append(", valueA: ");
		result.append(valueA);
		result.append(", unit: ");
		result.append(unit);
		result.append(')');
		return result.toString();
	}

} //SensorAImpl
