/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>PClass</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.PClass#getProxyReferences <em>Proxy References</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.PClass#getIdFeatures <em>Id Features</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.semantic.SemanticPackage#getPClass()
 * @model
 * @generated
 */
@ProviderType
public interface PClass extends EClass, Proxy {
	/**
	 * Returns the value of the '<em><b>Proxy References</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Proxy References</em>' reference.
	 * @see #setProxyReferences(PClass)
	 * @see org.gecko.emf.semantic.SemanticPackage#getPClass_ProxyReferences()
	 * @model
	 * @generated
	 */
	PClass getProxyReferences();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semantic.PClass#getProxyReferences <em>Proxy References</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Proxy References</em>' reference.
	 * @see #getProxyReferences()
	 * @generated
	 */
	void setProxyReferences(PClass value);

	/**
	 * Returns the value of the '<em><b>Id Features</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.EStructuralFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id Features</em>' reference list.
	 * @see org.gecko.emf.semantic.SemanticPackage#getPClass_IdFeatures()
	 * @model
	 * @generated
	 */
	EList<EStructuralFeature> getIdFeatures();

} // PClass
