/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>PObject</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.PObject#getProxyClass <em>Proxy Class</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.semantic.SemanticPackage#getPObject()
 * @model features="sourceDelegate" 
 *        sourceDelegateType="org.eclipse.emf.ecore.EObject" sourceDelegateMany="true" sourceDelegateSuppressedGetVisibility="true" sourceDelegateSuppressedSetVisibility="true" sourceDelegateSuppressedIsSetVisibility="true" sourceDelegateSuppressedUnsetVisibility="true"
 * @generated
 */
@ProviderType
public interface PObject extends EObject {
	/**
	 * Returns the value of the '<em><b>Proxy Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Proxy Class</em>' reference.
	 * @see org.gecko.emf.semantic.SemanticPackage#getPObject_ProxyClass()
	 * @model required="true" suppressedSetVisibility="true" suppressedIsSetVisibility="true" suppressedUnsetVisibility="true"
	 * @generated
	 */
	PClass getProxyClass();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model proxyFeatureRequired="true"
	 * @generated
	 */
	Object pGet(ProxyFeature proxyFeature);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model proxyFeatureRequired="true"
	 * @generated
	 */
	Object pGet(ProxyFeature proxyFeature, boolean resolve);

} // PObject
