/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Proxy</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.Proxy#getSemantic <em>Semantic</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.Proxy#getMetadata <em>Metadata</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.semantic.SemanticPackage#getProxy()
 * @model
 * @generated
 */
@ProviderType
public interface Proxy extends EObject {
	/**
	 * Returns the value of the '<em><b>Semantic</b></em>' reference list.
	 * The list contents are of type {@link org.gecko.emf.semantic.Semantic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Semantic</em>' reference list.
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxy_Semantic()
	 * @model
	 * @generated
	 */
	EList<Semantic> getSemantic();

	/**
	 * Returns the value of the '<em><b>Metadata</b></em>' reference list.
	 * The list contents are of type {@link org.gecko.emf.semantic.ProxyMetadata}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Metadata</em>' reference list.
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxy_Metadata()
	 * @model
	 * @generated
	 */
	EList<ProxyMetadata> getMetadata();

} // Proxy
