/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Proxy Feature</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.ProxyFeature#getSourceFeatures <em>Source Features</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.semantic.SemanticPackage#getProxyFeature()
 * @model interface="true" abstract="true"
 * @generated
 */
@ProviderType
public interface ProxyFeature extends Proxy {
	/**
	 * Returns the value of the '<em><b>Source Features</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source Features</em>' reference.
	 * @see #setSourceFeatures(EStructuralFeature)
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxyFeature_SourceFeatures()
	 * @model required="true"
	 * @generated
	 */
	EStructuralFeature getSourceFeatures();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semantic.ProxyFeature#getSourceFeatures <em>Source Features</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Features</em>' reference.
	 * @see #getSourceFeatures()
	 * @generated
	 */
	void setSourceFeatures(EStructuralFeature value);

} // ProxyFeature
