/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Proxy Metadata</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.ProxyMetadata#getKeyFeatures <em>Key Features</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.ProxyMetadata#getKey <em>Key</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.ProxyMetadata#getValueFeatures <em>Value Features</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.ProxyMetadata#getValue <em>Value</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.ProxyMetadata#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.ProxyMetadata#getNamespace <em>Namespace</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.semantic.SemanticPackage#getProxyMetadata()
 * @model
 * @generated
 */
@ProviderType
public interface ProxyMetadata extends EObject {
	/**
	 * Returns the value of the '<em><b>Key Features</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.EStructuralFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Key Features</em>' reference list.
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxyMetadata_KeyFeatures()
	 * @model
	 * @generated
	 */
	EList<EStructuralFeature> getKeyFeatures();

	/**
	 * Returns the value of the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Key</em>' attribute.
	 * @see #setKey(String)
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxyMetadata_Key()
	 * @model
	 * @generated
	 */
	String getKey();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semantic.ProxyMetadata#getKey <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Key</em>' attribute.
	 * @see #getKey()
	 * @generated
	 */
	void setKey(String value);

	/**
	 * Returns the value of the '<em><b>Value Features</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.EStructuralFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value Features</em>' reference list.
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxyMetadata_ValueFeatures()
	 * @model
	 * @generated
	 */
	EList<EStructuralFeature> getValueFeatures();

	/**
	 * Returns the value of the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value</em>' attribute.
	 * @see #setValue(Object)
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxyMetadata_Value()
	 * @model
	 * @generated
	 */
	Object getValue();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semantic.ProxyMetadata#getValue <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value</em>' attribute.
	 * @see #getValue()
	 * @generated
	 */
	void setValue(Object value);

	/**
	 * Returns the value of the '<em><b>Timestamp</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.EStructuralFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Timestamp</em>' reference list.
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxyMetadata_Timestamp()
	 * @model
	 * @generated
	 */
	EList<EStructuralFeature> getTimestamp();

	/**
	 * Returns the value of the '<em><b>Namespace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Namespace</em>' attribute.
	 * @see #setNamespace(String)
	 * @see org.gecko.emf.semantic.SemanticPackage#getProxyMetadata_Namespace()
	 * @model
	 * @generated
	 */
	String getNamespace();

	/**
	 * Sets the value of the '{@link org.gecko.emf.semantic.ProxyMetadata#getNamespace <em>Namespace</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Namespace</em>' attribute.
	 * @see #getNamespace()
	 * @generated
	 */
	void setNamespace(String value);

} // ProxyMetadata
