/**
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic.ecore;

import static java.util.Objects.nonNull;
import static java.util.Objects.requireNonNull;

import java.util.Arrays;

import org.eclipse.emf.ecore.EObject;
import org.gecko.emf.semantic.PClass;
import org.gecko.emf.semantic.PObject;
import org.gecko.emf.semantic.SemanticFactory;
import org.gecko.emf.semantic.impl.PObjectImpl;

/**
 * Proxy ecore Utilities
 * @author Mark Hoffmann
 * @since 16.05.2024
 */
public class ProxyUtil {
	
	/**
	 * Creates a proxy instance for the given proxy class
	 * @param pClass the proxy class, must not be <code>null</code>
	 * @return the proxy instance
	 */
	public static PObject createProxy(PClass pClass) {
		return createProxy(pClass, new EObject[0]);
	}
	
	/**
	 * Creates a proxy instance for the given proxy class
	 * @param pClass the proxy class, must not be <code>null</code>
	 * @param sourceObjects the source objects, that conforms to the pClass parameter settings
	 * @return the proxy instance
	 */
	public static PObject createProxy(PClass pClass, EObject... sourceObjects) {
		requireNonNull(pClass);
		PObjectImpl pObject = (PObjectImpl) SemanticFactory.eINSTANCE.createPObject();
		pObject.setProxyClass(pClass);
		if (nonNull(sourceObjects)) {
			Arrays.asList(sourceObjects).forEach(pObject.getSourceDelegate()::add);
		}
		return pObject;
	}
	

}
