/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.gecko.emf.semantic.PClass;
import org.gecko.emf.semantic.Proxy;
import org.gecko.emf.semantic.ProxyMetadata;
import org.gecko.emf.semantic.Semantic;
import org.gecko.emf.semantic.SemanticPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>PClass</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.impl.PClassImpl#getSemantic <em>Semantic</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.PClassImpl#getMetadata <em>Metadata</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.PClassImpl#getProxyReferences <em>Proxy References</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.PClassImpl#getIdFeatures <em>Id Features</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PClassImpl extends EClassImpl implements PClass {
	/**
	 * The cached value of the '{@link #getSemantic() <em>Semantic</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSemantic()
	 * @generated
	 * @ordered
	 */
	protected EList<Semantic> semantic;

	/**
	 * The cached value of the '{@link #getMetadata() <em>Metadata</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetadata()
	 * @generated
	 * @ordered
	 */
	protected EList<ProxyMetadata> metadata;

	/**
	 * The cached value of the '{@link #getProxyReferences() <em>Proxy References</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProxyReferences()
	 * @generated
	 * @ordered
	 */
	protected PClass proxyReferences;

	/**
	 * The cached value of the '{@link #getIdFeatures() <em>Id Features</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdFeatures()
	 * @generated
	 * @ordered
	 */
	protected EList<EStructuralFeature> idFeatures;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PClassImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SemanticPackage.Literals.PCLASS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Semantic> getSemantic() {
		if (semantic == null) {
			semantic = new EObjectResolvingEList<Semantic>(Semantic.class, this, SemanticPackage.PCLASS__SEMANTIC);
		}
		return semantic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ProxyMetadata> getMetadata() {
		if (metadata == null) {
			metadata = new EObjectResolvingEList<ProxyMetadata>(ProxyMetadata.class, this, SemanticPackage.PCLASS__METADATA);
		}
		return metadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PClass getProxyReferences() {
		if (proxyReferences != null && proxyReferences.eIsProxy()) {
			InternalEObject oldProxyReferences = (InternalEObject)proxyReferences;
			proxyReferences = (PClass)eResolveProxy(oldProxyReferences);
			if (proxyReferences != oldProxyReferences) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SemanticPackage.PCLASS__PROXY_REFERENCES, oldProxyReferences, proxyReferences));
			}
		}
		return proxyReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PClass basicGetProxyReferences() {
		return proxyReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProxyReferences(PClass newProxyReferences) {
		PClass oldProxyReferences = proxyReferences;
		proxyReferences = newProxyReferences;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemanticPackage.PCLASS__PROXY_REFERENCES, oldProxyReferences, proxyReferences));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EStructuralFeature> getIdFeatures() {
		if (idFeatures == null) {
			idFeatures = new EObjectResolvingEList<EStructuralFeature>(EStructuralFeature.class, this, SemanticPackage.PCLASS__ID_FEATURES);
		}
		return idFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SemanticPackage.PCLASS__SEMANTIC:
				return getSemantic();
			case SemanticPackage.PCLASS__METADATA:
				return getMetadata();
			case SemanticPackage.PCLASS__PROXY_REFERENCES:
				if (resolve) return getProxyReferences();
				return basicGetProxyReferences();
			case SemanticPackage.PCLASS__ID_FEATURES:
				return getIdFeatures();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SemanticPackage.PCLASS__SEMANTIC:
				getSemantic().clear();
				getSemantic().addAll((Collection<? extends Semantic>)newValue);
				return;
			case SemanticPackage.PCLASS__METADATA:
				getMetadata().clear();
				getMetadata().addAll((Collection<? extends ProxyMetadata>)newValue);
				return;
			case SemanticPackage.PCLASS__PROXY_REFERENCES:
				setProxyReferences((PClass)newValue);
				return;
			case SemanticPackage.PCLASS__ID_FEATURES:
				getIdFeatures().clear();
				getIdFeatures().addAll((Collection<? extends EStructuralFeature>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SemanticPackage.PCLASS__SEMANTIC:
				getSemantic().clear();
				return;
			case SemanticPackage.PCLASS__METADATA:
				getMetadata().clear();
				return;
			case SemanticPackage.PCLASS__PROXY_REFERENCES:
				setProxyReferences((PClass)null);
				return;
			case SemanticPackage.PCLASS__ID_FEATURES:
				getIdFeatures().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SemanticPackage.PCLASS__SEMANTIC:
				return semantic != null && !semantic.isEmpty();
			case SemanticPackage.PCLASS__METADATA:
				return metadata != null && !metadata.isEmpty();
			case SemanticPackage.PCLASS__PROXY_REFERENCES:
				return proxyReferences != null;
			case SemanticPackage.PCLASS__ID_FEATURES:
				return idFeatures != null && !idFeatures.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Proxy.class) {
			switch (derivedFeatureID) {
				case SemanticPackage.PCLASS__SEMANTIC: return SemanticPackage.PROXY__SEMANTIC;
				case SemanticPackage.PCLASS__METADATA: return SemanticPackage.PROXY__METADATA;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Proxy.class) {
			switch (baseFeatureID) {
				case SemanticPackage.PROXY__SEMANTIC: return SemanticPackage.PCLASS__SEMANTIC;
				case SemanticPackage.PROXY__METADATA: return SemanticPackage.PCLASS__METADATA;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //PClassImpl
