/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.gecko.emf.semantic.PClass;
import org.gecko.emf.semantic.PObject;
import org.gecko.emf.semantic.ProxyFeature;
import org.gecko.emf.semantic.SemanticPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>PObject</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.impl.PObjectImpl#getProxyClass <em>Proxy Class</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.PObjectImpl#getSourceDelegate <em>Source Delegate</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PObjectImpl extends EObjectImpl implements PObject {
	/**
	 * The cached value of the '{@link #getProxyClass() <em>Proxy Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProxyClass()
	 * @generated
	 * @ordered
	 */
	protected PClass proxyClass;

	/**
	 * The cached value of the '{@link #getSourceDelegate() <em>Source Delegate</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceDelegate()
	 * @generated
	 * @ordered
	 */
	protected EList<EObject> sourceDelegate;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SemanticPackage.Literals.POBJECT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PClass getProxyClass() {
		if (proxyClass != null && proxyClass.eIsProxy()) {
			InternalEObject oldProxyClass = (InternalEObject)proxyClass;
			proxyClass = (PClass)eResolveProxy(oldProxyClass);
			if (proxyClass != oldProxyClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SemanticPackage.POBJECT__PROXY_CLASS, oldProxyClass, proxyClass));
			}
		}
		return proxyClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PClass basicGetProxyClass() {
		return proxyClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProxyClass(PClass newProxyClass) {
		PClass oldProxyClass = proxyClass;
		proxyClass = newProxyClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemanticPackage.POBJECT__PROXY_CLASS, oldProxyClass, proxyClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EObject> getSourceDelegate() {
		if (sourceDelegate == null) {
			sourceDelegate = new EObjectResolvingEList<EObject>(EObject.class, this, SemanticPackage.POBJECT__SOURCE_DELEGATE);
		}
		return sourceDelegate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object pGet(ProxyFeature proxyFeature) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object pGet(ProxyFeature proxyFeature, boolean resolve) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SemanticPackage.POBJECT__PROXY_CLASS:
				if (resolve) return getProxyClass();
				return basicGetProxyClass();
			case SemanticPackage.POBJECT__SOURCE_DELEGATE:
				return getSourceDelegate();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SemanticPackage.POBJECT__PROXY_CLASS:
				setProxyClass((PClass)newValue);
				return;
			case SemanticPackage.POBJECT__SOURCE_DELEGATE:
				getSourceDelegate().clear();
				getSourceDelegate().addAll((Collection<? extends EObject>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SemanticPackage.POBJECT__PROXY_CLASS:
				setProxyClass((PClass)null);
				return;
			case SemanticPackage.POBJECT__SOURCE_DELEGATE:
				getSourceDelegate().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SemanticPackage.POBJECT__PROXY_CLASS:
				return proxyClass != null;
			case SemanticPackage.POBJECT__SOURCE_DELEGATE:
				return sourceDelegate != null && !sourceDelegate.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case SemanticPackage.POBJECT___PGET__PROXYFEATURE:
				return pGet((ProxyFeature)arguments.get(0));
			case SemanticPackage.POBJECT___PGET__PROXYFEATURE_BOOLEAN:
				return pGet((ProxyFeature)arguments.get(0), (Boolean)arguments.get(1));
		}
		return super.eInvoke(operationID, arguments);
	}

} //PObjectImpl
