/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.gecko.emf.semantic.PPackage;
import org.gecko.emf.semantic.Proxy;
import org.gecko.emf.semantic.ProxyMetadata;
import org.gecko.emf.semantic.Semantic;
import org.gecko.emf.semantic.SemanticPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>PPackage</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.impl.PPackageImpl#getSemantic <em>Semantic</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.PPackageImpl#getMetadata <em>Metadata</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PPackageImpl extends EPackageImpl implements PPackage {
	/**
	 * The cached value of the '{@link #getSemantic() <em>Semantic</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSemantic()
	 * @generated
	 * @ordered
	 */
	protected EList<Semantic> semantic;

	/**
	 * The cached value of the '{@link #getMetadata() <em>Metadata</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetadata()
	 * @generated
	 * @ordered
	 */
	protected EList<ProxyMetadata> metadata;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PPackageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SemanticPackage.Literals.PPACKAGE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Semantic> getSemantic() {
		if (semantic == null) {
			semantic = new EObjectResolvingEList<Semantic>(Semantic.class, this, SemanticPackage.PPACKAGE__SEMANTIC);
		}
		return semantic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ProxyMetadata> getMetadata() {
		if (metadata == null) {
			metadata = new EObjectResolvingEList<ProxyMetadata>(ProxyMetadata.class, this, SemanticPackage.PPACKAGE__METADATA);
		}
		return metadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SemanticPackage.PPACKAGE__SEMANTIC:
				return getSemantic();
			case SemanticPackage.PPACKAGE__METADATA:
				return getMetadata();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SemanticPackage.PPACKAGE__SEMANTIC:
				getSemantic().clear();
				getSemantic().addAll((Collection<? extends Semantic>)newValue);
				return;
			case SemanticPackage.PPACKAGE__METADATA:
				getMetadata().clear();
				getMetadata().addAll((Collection<? extends ProxyMetadata>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SemanticPackage.PPACKAGE__SEMANTIC:
				getSemantic().clear();
				return;
			case SemanticPackage.PPACKAGE__METADATA:
				getMetadata().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SemanticPackage.PPACKAGE__SEMANTIC:
				return semantic != null && !semantic.isEmpty();
			case SemanticPackage.PPACKAGE__METADATA:
				return metadata != null && !metadata.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Proxy.class) {
			switch (derivedFeatureID) {
				case SemanticPackage.PPACKAGE__SEMANTIC: return SemanticPackage.PROXY__SEMANTIC;
				case SemanticPackage.PPACKAGE__METADATA: return SemanticPackage.PROXY__METADATA;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Proxy.class) {
			switch (baseFeatureID) {
				case SemanticPackage.PROXY__SEMANTIC: return SemanticPackage.PPACKAGE__SEMANTIC;
				case SemanticPackage.PROXY__METADATA: return SemanticPackage.PPACKAGE__METADATA;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //PPackageImpl
