/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EReferenceImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.gecko.emf.semantic.PReference;
import org.gecko.emf.semantic.Proxy;
import org.gecko.emf.semantic.ProxyFeature;
import org.gecko.emf.semantic.ProxyMetadata;
import org.gecko.emf.semantic.Semantic;
import org.gecko.emf.semantic.SemanticPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>PReference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.impl.PReferenceImpl#getSemantic <em>Semantic</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.PReferenceImpl#getMetadata <em>Metadata</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.PReferenceImpl#getSourceFeatures <em>Source Features</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PReferenceImpl extends EReferenceImpl implements PReference {
	/**
	 * The cached value of the '{@link #getSemantic() <em>Semantic</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSemantic()
	 * @generated
	 * @ordered
	 */
	protected EList<Semantic> semantic;

	/**
	 * The cached value of the '{@link #getMetadata() <em>Metadata</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetadata()
	 * @generated
	 * @ordered
	 */
	protected EList<ProxyMetadata> metadata;

	/**
	 * The cached value of the '{@link #getSourceFeatures() <em>Source Features</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceFeatures()
	 * @generated
	 * @ordered
	 */
	protected EStructuralFeature sourceFeatures;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SemanticPackage.Literals.PREFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Semantic> getSemantic() {
		if (semantic == null) {
			semantic = new EObjectResolvingEList<Semantic>(Semantic.class, this, SemanticPackage.PREFERENCE__SEMANTIC);
		}
		return semantic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ProxyMetadata> getMetadata() {
		if (metadata == null) {
			metadata = new EObjectResolvingEList<ProxyMetadata>(ProxyMetadata.class, this, SemanticPackage.PREFERENCE__METADATA);
		}
		return metadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EStructuralFeature getSourceFeatures() {
		if (sourceFeatures != null && sourceFeatures.eIsProxy()) {
			InternalEObject oldSourceFeatures = (InternalEObject)sourceFeatures;
			sourceFeatures = (EStructuralFeature)eResolveProxy(oldSourceFeatures);
			if (sourceFeatures != oldSourceFeatures) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SemanticPackage.PREFERENCE__SOURCE_FEATURES, oldSourceFeatures, sourceFeatures));
			}
		}
		return sourceFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EStructuralFeature basicGetSourceFeatures() {
		return sourceFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSourceFeatures(EStructuralFeature newSourceFeatures) {
		EStructuralFeature oldSourceFeatures = sourceFeatures;
		sourceFeatures = newSourceFeatures;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemanticPackage.PREFERENCE__SOURCE_FEATURES, oldSourceFeatures, sourceFeatures));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SemanticPackage.PREFERENCE__SEMANTIC:
				return getSemantic();
			case SemanticPackage.PREFERENCE__METADATA:
				return getMetadata();
			case SemanticPackage.PREFERENCE__SOURCE_FEATURES:
				if (resolve) return getSourceFeatures();
				return basicGetSourceFeatures();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SemanticPackage.PREFERENCE__SEMANTIC:
				getSemantic().clear();
				getSemantic().addAll((Collection<? extends Semantic>)newValue);
				return;
			case SemanticPackage.PREFERENCE__METADATA:
				getMetadata().clear();
				getMetadata().addAll((Collection<? extends ProxyMetadata>)newValue);
				return;
			case SemanticPackage.PREFERENCE__SOURCE_FEATURES:
				setSourceFeatures((EStructuralFeature)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SemanticPackage.PREFERENCE__SEMANTIC:
				getSemantic().clear();
				return;
			case SemanticPackage.PREFERENCE__METADATA:
				getMetadata().clear();
				return;
			case SemanticPackage.PREFERENCE__SOURCE_FEATURES:
				setSourceFeatures((EStructuralFeature)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SemanticPackage.PREFERENCE__SEMANTIC:
				return semantic != null && !semantic.isEmpty();
			case SemanticPackage.PREFERENCE__METADATA:
				return metadata != null && !metadata.isEmpty();
			case SemanticPackage.PREFERENCE__SOURCE_FEATURES:
				return sourceFeatures != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Proxy.class) {
			switch (derivedFeatureID) {
				case SemanticPackage.PREFERENCE__SEMANTIC: return SemanticPackage.PROXY__SEMANTIC;
				case SemanticPackage.PREFERENCE__METADATA: return SemanticPackage.PROXY__METADATA;
				default: return -1;
			}
		}
		if (baseClass == ProxyFeature.class) {
			switch (derivedFeatureID) {
				case SemanticPackage.PREFERENCE__SOURCE_FEATURES: return SemanticPackage.PROXY_FEATURE__SOURCE_FEATURES;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Proxy.class) {
			switch (baseFeatureID) {
				case SemanticPackage.PROXY__SEMANTIC: return SemanticPackage.PREFERENCE__SEMANTIC;
				case SemanticPackage.PROXY__METADATA: return SemanticPackage.PREFERENCE__METADATA;
				default: return -1;
			}
		}
		if (baseClass == ProxyFeature.class) {
			switch (baseFeatureID) {
				case SemanticPackage.PROXY_FEATURE__SOURCE_FEATURES: return SemanticPackage.PREFERENCE__SOURCE_FEATURES;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //PReferenceImpl
