/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.gecko.emf.semantic.ProxyMetadata;
import org.gecko.emf.semantic.SemanticPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Proxy Metadata</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.semantic.impl.ProxyMetadataImpl#getKeyFeatures <em>Key Features</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.ProxyMetadataImpl#getKey <em>Key</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.ProxyMetadataImpl#getValueFeatures <em>Value Features</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.ProxyMetadataImpl#getValue <em>Value</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.ProxyMetadataImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.emf.semantic.impl.ProxyMetadataImpl#getNamespace <em>Namespace</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProxyMetadataImpl extends MinimalEObjectImpl.Container implements ProxyMetadata {
	/**
	 * The cached value of the '{@link #getKeyFeatures() <em>Key Features</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeyFeatures()
	 * @generated
	 * @ordered
	 */
	protected EList<EStructuralFeature> keyFeatures;

	/**
	 * The default value of the '{@link #getKey() <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKey()
	 * @generated
	 * @ordered
	 */
	protected static final String KEY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKey() <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKey()
	 * @generated
	 * @ordered
	 */
	protected String key = KEY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getValueFeatures() <em>Value Features</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueFeatures()
	 * @generated
	 * @ordered
	 */
	protected EList<EStructuralFeature> valueFeatures;

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final Object VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected Object value = VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected EList<EStructuralFeature> timestamp;

	/**
	 * The default value of the '{@link #getNamespace() <em>Namespace</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNamespace()
	 * @generated
	 * @ordered
	 */
	protected static final String NAMESPACE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getNamespace() <em>Namespace</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNamespace()
	 * @generated
	 * @ordered
	 */
	protected String namespace = NAMESPACE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProxyMetadataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SemanticPackage.Literals.PROXY_METADATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EStructuralFeature> getKeyFeatures() {
		if (keyFeatures == null) {
			keyFeatures = new EObjectResolvingEList<EStructuralFeature>(EStructuralFeature.class, this, SemanticPackage.PROXY_METADATA__KEY_FEATURES);
		}
		return keyFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getKey() {
		return key;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKey(String newKey) {
		String oldKey = key;
		key = newKey;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemanticPackage.PROXY_METADATA__KEY, oldKey, key));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EStructuralFeature> getValueFeatures() {
		if (valueFeatures == null) {
			valueFeatures = new EObjectResolvingEList<EStructuralFeature>(EStructuralFeature.class, this, SemanticPackage.PROXY_METADATA__VALUE_FEATURES);
		}
		return valueFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setValue(Object newValue) {
		Object oldValue = value;
		value = newValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemanticPackage.PROXY_METADATA__VALUE, oldValue, value));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EStructuralFeature> getTimestamp() {
		if (timestamp == null) {
			timestamp = new EObjectResolvingEList<EStructuralFeature>(EStructuralFeature.class, this, SemanticPackage.PROXY_METADATA__TIMESTAMP);
		}
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getNamespace() {
		return namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNamespace(String newNamespace) {
		String oldNamespace = namespace;
		namespace = newNamespace;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SemanticPackage.PROXY_METADATA__NAMESPACE, oldNamespace, namespace));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SemanticPackage.PROXY_METADATA__KEY_FEATURES:
				return getKeyFeatures();
			case SemanticPackage.PROXY_METADATA__KEY:
				return getKey();
			case SemanticPackage.PROXY_METADATA__VALUE_FEATURES:
				return getValueFeatures();
			case SemanticPackage.PROXY_METADATA__VALUE:
				return getValue();
			case SemanticPackage.PROXY_METADATA__TIMESTAMP:
				return getTimestamp();
			case SemanticPackage.PROXY_METADATA__NAMESPACE:
				return getNamespace();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SemanticPackage.PROXY_METADATA__KEY_FEATURES:
				getKeyFeatures().clear();
				getKeyFeatures().addAll((Collection<? extends EStructuralFeature>)newValue);
				return;
			case SemanticPackage.PROXY_METADATA__KEY:
				setKey((String)newValue);
				return;
			case SemanticPackage.PROXY_METADATA__VALUE_FEATURES:
				getValueFeatures().clear();
				getValueFeatures().addAll((Collection<? extends EStructuralFeature>)newValue);
				return;
			case SemanticPackage.PROXY_METADATA__VALUE:
				setValue(newValue);
				return;
			case SemanticPackage.PROXY_METADATA__TIMESTAMP:
				getTimestamp().clear();
				getTimestamp().addAll((Collection<? extends EStructuralFeature>)newValue);
				return;
			case SemanticPackage.PROXY_METADATA__NAMESPACE:
				setNamespace((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SemanticPackage.PROXY_METADATA__KEY_FEATURES:
				getKeyFeatures().clear();
				return;
			case SemanticPackage.PROXY_METADATA__KEY:
				setKey(KEY_EDEFAULT);
				return;
			case SemanticPackage.PROXY_METADATA__VALUE_FEATURES:
				getValueFeatures().clear();
				return;
			case SemanticPackage.PROXY_METADATA__VALUE:
				setValue(VALUE_EDEFAULT);
				return;
			case SemanticPackage.PROXY_METADATA__TIMESTAMP:
				getTimestamp().clear();
				return;
			case SemanticPackage.PROXY_METADATA__NAMESPACE:
				setNamespace(NAMESPACE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SemanticPackage.PROXY_METADATA__KEY_FEATURES:
				return keyFeatures != null && !keyFeatures.isEmpty();
			case SemanticPackage.PROXY_METADATA__KEY:
				return KEY_EDEFAULT == null ? key != null : !KEY_EDEFAULT.equals(key);
			case SemanticPackage.PROXY_METADATA__VALUE_FEATURES:
				return valueFeatures != null && !valueFeatures.isEmpty();
			case SemanticPackage.PROXY_METADATA__VALUE:
				return VALUE_EDEFAULT == null ? value != null : !VALUE_EDEFAULT.equals(value);
			case SemanticPackage.PROXY_METADATA__TIMESTAMP:
				return timestamp != null && !timestamp.isEmpty();
			case SemanticPackage.PROXY_METADATA__NAMESPACE:
				return NAMESPACE_EDEFAULT == null ? namespace != null : !NAMESPACE_EDEFAULT.equals(namespace);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (key: ");
		result.append(key);
		result.append(", value: ");
		result.append(value);
		result.append(", namespace: ");
		result.append(namespace);
		result.append(')');
		return result.toString();
	}

} //ProxyMetadataImpl
