/**
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.semantic.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.emf.semantic.PAttribute;
import org.gecko.emf.semantic.PClass;
import org.gecko.emf.semantic.PObject;
import org.gecko.emf.semantic.PPackage;
import org.gecko.emf.semantic.PReference;
import org.gecko.emf.semantic.Proxy;
import org.gecko.emf.semantic.ProxyFeature;
import org.gecko.emf.semantic.ProxyMetadata;
import org.gecko.emf.semantic.Semantic;
import org.gecko.emf.semantic.SemanticFactory;
import org.gecko.emf.semantic.SemanticPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SemanticPackageImpl extends EPackageImpl implements SemanticPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pClassEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass proxyFeatureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pObjectEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pReferenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pPackageEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass semanticEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass proxyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass proxyMetadataEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.emf.semantic.SemanticPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private SemanticPackageImpl() {
		super(eNS_URI, SemanticFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link SemanticPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static SemanticPackage init() {
		if (isInited) return (SemanticPackage)EPackage.Registry.INSTANCE.getEPackage(SemanticPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredSemanticPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		SemanticPackageImpl theSemanticPackage = registeredSemanticPackage instanceof SemanticPackageImpl ? (SemanticPackageImpl)registeredSemanticPackage : new SemanticPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theSemanticPackage.createPackageContents();

		// Initialize created meta-data
		theSemanticPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theSemanticPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(SemanticPackage.eNS_URI, theSemanticPackage);
		return theSemanticPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPClass() {
		return pClassEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPClass_ProxyReferences() {
		return (EReference)pClassEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPClass_IdFeatures() {
		return (EReference)pClassEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProxyFeature() {
		return proxyFeatureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProxyFeature_SourceFeatures() {
		return (EReference)proxyFeatureEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPObject() {
		return pObjectEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPObject_ProxyClass() {
		return (EReference)pObjectEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPObject_SourceDelegate() {
		return (EReference)pObjectEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getPObject__PGet__ProxyFeature() {
		return pObjectEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getPObject__PGet__ProxyFeature_boolean() {
		return pObjectEClass.getEOperations().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPAttribute() {
		return pAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPReference() {
		return pReferenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPPackage() {
		return pPackageEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSemantic() {
		return semanticEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProxy() {
		return proxyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProxy_Semantic() {
		return (EReference)proxyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProxy_Metadata() {
		return (EReference)proxyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProxyMetadata() {
		return proxyMetadataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProxyMetadata_KeyFeatures() {
		return (EReference)proxyMetadataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getProxyMetadata_Key() {
		return (EAttribute)proxyMetadataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProxyMetadata_ValueFeatures() {
		return (EReference)proxyMetadataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getProxyMetadata_Value() {
		return (EAttribute)proxyMetadataEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProxyMetadata_Timestamp() {
		return (EReference)proxyMetadataEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getProxyMetadata_Namespace() {
		return (EAttribute)proxyMetadataEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SemanticFactory getSemanticFactory() {
		return (SemanticFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		pClassEClass = createEClass(PCLASS);
		createEReference(pClassEClass, PCLASS__PROXY_REFERENCES);
		createEReference(pClassEClass, PCLASS__ID_FEATURES);

		proxyFeatureEClass = createEClass(PROXY_FEATURE);
		createEReference(proxyFeatureEClass, PROXY_FEATURE__SOURCE_FEATURES);

		pObjectEClass = createEClass(POBJECT);
		createEReference(pObjectEClass, POBJECT__PROXY_CLASS);
		createEReference(pObjectEClass, POBJECT__SOURCE_DELEGATE);
		createEOperation(pObjectEClass, POBJECT___PGET__PROXYFEATURE);
		createEOperation(pObjectEClass, POBJECT___PGET__PROXYFEATURE_BOOLEAN);

		pAttributeEClass = createEClass(PATTRIBUTE);

		pReferenceEClass = createEClass(PREFERENCE);

		pPackageEClass = createEClass(PPACKAGE);

		semanticEClass = createEClass(SEMANTIC);

		proxyEClass = createEClass(PROXY);
		createEReference(proxyEClass, PROXY__SEMANTIC);
		createEReference(proxyEClass, PROXY__METADATA);

		proxyMetadataEClass = createEClass(PROXY_METADATA);
		createEReference(proxyMetadataEClass, PROXY_METADATA__KEY_FEATURES);
		createEAttribute(proxyMetadataEClass, PROXY_METADATA__KEY);
		createEReference(proxyMetadataEClass, PROXY_METADATA__VALUE_FEATURES);
		createEAttribute(proxyMetadataEClass, PROXY_METADATA__VALUE);
		createEReference(proxyMetadataEClass, PROXY_METADATA__TIMESTAMP);
		createEAttribute(proxyMetadataEClass, PROXY_METADATA__NAMESPACE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		pClassEClass.getESuperTypes().add(theEcorePackage.getEClass());
		pClassEClass.getESuperTypes().add(this.getProxy());
		proxyFeatureEClass.getESuperTypes().add(this.getProxy());
		pObjectEClass.getESuperTypes().add(theEcorePackage.getEObject());
		pAttributeEClass.getESuperTypes().add(theEcorePackage.getEAttribute());
		pAttributeEClass.getESuperTypes().add(this.getProxyFeature());
		pReferenceEClass.getESuperTypes().add(theEcorePackage.getEReference());
		pReferenceEClass.getESuperTypes().add(this.getProxyFeature());
		pPackageEClass.getESuperTypes().add(theEcorePackage.getEPackage());
		pPackageEClass.getESuperTypes().add(this.getProxy());

		// Initialize classes, features, and operations; add parameters
		initEClass(pClassEClass, PClass.class, "PClass", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPClass_ProxyReferences(), this.getPClass(), null, "proxyReferences", null, 0, 1, PClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPClass_IdFeatures(), theEcorePackage.getEStructuralFeature(), null, "idFeatures", null, 0, -1, PClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(proxyFeatureEClass, ProxyFeature.class, "ProxyFeature", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProxyFeature_SourceFeatures(), theEcorePackage.getEStructuralFeature(), null, "sourceFeatures", null, 1, 1, ProxyFeature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(pObjectEClass, PObject.class, "PObject", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPObject_ProxyClass(), this.getPClass(), null, "proxyClass", null, 1, 1, PObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPObject_SourceDelegate(), ecorePackage.getEObject(), null, "sourceDelegate", null, 0, -1, PObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		EOperation op = initEOperation(getPObject__PGet__ProxyFeature(), ecorePackage.getEJavaObject(), "pGet", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getProxyFeature(), "proxyFeature", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getPObject__PGet__ProxyFeature_boolean(), ecorePackage.getEJavaObject(), "pGet", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getProxyFeature(), "proxyFeature", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEBoolean(), "resolve", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(pAttributeEClass, PAttribute.class, "PAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(pReferenceEClass, PReference.class, "PReference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(pPackageEClass, PPackage.class, "PPackage", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(semanticEClass, Semantic.class, "Semantic", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(proxyEClass, Proxy.class, "Proxy", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProxy_Semantic(), this.getSemantic(), null, "semantic", null, 0, -1, Proxy.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProxy_Metadata(), this.getProxyMetadata(), null, "metadata", null, 0, -1, Proxy.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(proxyMetadataEClass, ProxyMetadata.class, "ProxyMetadata", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProxyMetadata_KeyFeatures(), theEcorePackage.getEStructuralFeature(), null, "keyFeatures", null, 0, -1, ProxyMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProxyMetadata_Key(), theEcorePackage.getEString(), "key", null, 0, 1, ProxyMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProxyMetadata_ValueFeatures(), theEcorePackage.getEStructuralFeature(), null, "valueFeatures", null, 0, -1, ProxyMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProxyMetadata_Value(), ecorePackage.getEJavaObject(), "value", null, 0, 1, ProxyMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProxyMetadata_Timestamp(), theEcorePackage.getEStructuralFeature(), null, "timestamp", null, 0, -1, ProxyMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProxyMetadata_Namespace(), theEcorePackage.getEString(), "namespace", null, 0, 1, ProxyMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} //SemanticPackageImpl
