/*
 * Copyright 2025 Dynatrace LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.dynatrace.hash4j.internal;

/** Utility class defining empty arrays. */
public final class EmptyArray {

  private EmptyArray() {}

  /** An empty byte array. */
  public static byte[] EMPTY_BYTE_ARRAY = {};

  /** An empty short array. */
  public static short[] EMPTY_SHORT_ARRAY = {};

  /** An empty int array. */
  public static int[] EMPTY_INT_ARRAY = {};

  /** An empty long array. */
  public static long[] EMPTY_LONG_ARRAY = {};

  /** An empty boolean array. */
  public static boolean[] EMPTY_BOOLEAN_ARRAY = {};

  /** An empty float array. */
  public static float[] EMPTY_FLOAT_ARRAY = {};

  /** An empty double array. */
  public static double[] EMPTY_DOUBLE_ARRAY = {};

  /** An empty char array. */
  public static char[] EMPTY_CHAR_ARRAY = {};
}
