package io.apicurio.registry.rest.v3;

import io.apicurio.registry.rest.v3.beans.SystemInfo;
import io.apicurio.registry.rest.v3.beans.UserInterfaceConfig;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

/**
 * A JAX-RS interface. An implementation of this interface must be provided.
 */
@Path("/apis/registry/v3/system")
public interface SystemResource {
  /**
   * <p>
   * This operation retrieves information about the running registry system, such
   * as the version of the software and when it was built.
   * </p>
   * 
   */
  @Path("/info")
  @GET
  @Produces("application/json")
  SystemInfo getSystemInfo();

  /**
   * <p>
   * Returns the UI configuration properties for this server. The registry UI can
   * be connected to a backend using just a URL. The rest of the UI configuration
   * can then be fetched from the backend using this operation. This allows UI and
   * backend to both be configured in the same place.
   * </p>
   * <p>
   * This operation may fail for one of the following reasons:
   * </p>
   * <ul>
   * <li>A server error occurred (HTTP error <code>500</code>)</li>
   * </ul>
   * 
   */
  @Path("/uiConfig")
  @GET
  @Produces("application/json")
  UserInterfaceConfig getUIConfig();
}
