
package io.apicurio.registry.rest.v3.beans;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

@io.quarkus.runtime.annotations.RegisterForReflection
public enum GroupSortBy {

    groupId("groupId"),
    createdOn("createdOn"),
    modifiedOn("modifiedOn");
    private final String value;
    private final static Map<String, GroupSortBy> CONSTANTS = new HashMap<String, GroupSortBy>();

    static {
        for (GroupSortBy c: values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private GroupSortBy(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static GroupSortBy fromValue(String value) {
        GroupSortBy constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        } else {
            return constant;
        }
    }

}
