
package io.apicurio.registry.rest.v3.beans;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Root Type for Error
 * <p>
 * All error responses, whether `4xx` or `5xx` will include one of these as the response
 * body.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "causes",
    "detail",
    "type",
    "title",
    "status",
    "instance",
    "name"
})
@Generated("jsonschema2pojo")
@io.quarkus.runtime.annotations.RegisterForReflection
@lombok.experimental.SuperBuilder
@lombok.AllArgsConstructor
@lombok.NoArgsConstructor
@lombok.EqualsAndHashCode
@lombok.ToString(callSuper = true)
public class RuleViolationProblemDetails
    extends ProblemDetails
{

    /**
     * List of rule violation causes.
     * (Required)
     * 
     */
    @JsonProperty("causes")
    @JsonPropertyDescription("List of rule violation causes.")
    private List<RuleViolationCause> causes = new ArrayList<RuleViolationCause>();
    /**
     * A human-readable explanation specific to this occurrence of the problem.
     * 
     */
    @JsonProperty("detail")
    @JsonPropertyDescription("A human-readable explanation specific to this occurrence of the problem.")
    private String detail;
    /**
     * A URI reference [RFC3986] that identifies the problem type.
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("A URI reference [RFC3986] that identifies the problem type.")
    private String type;
    /**
     * A short, human-readable summary of the problem type.
     * (Required)
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("A short, human-readable summary of the problem type.")
    private String title;
    /**
     * The HTTP status code.
     * (Required)
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("The HTTP status code.")
    private Integer status;
    /**
     * A URI reference that identifies the specific occurrence of the problem.
     * 
     */
    @JsonProperty("instance")
    @JsonPropertyDescription("A URI reference that identifies the specific occurrence of the problem.")
    private String instance;
    /**
     * The name of the error (typically a server exception class name).
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("The name of the error (typically a server exception class name).")
    private String name;

    /**
     * List of rule violation causes.
     * (Required)
     * 
     */
    @JsonProperty("causes")
    public List<RuleViolationCause> getCauses() {
        return causes;
    }

    /**
     * List of rule violation causes.
     * (Required)
     * 
     */
    @JsonProperty("causes")
    public void setCauses(List<RuleViolationCause> causes) {
        this.causes = causes;
    }

    /**
     * A human-readable explanation specific to this occurrence of the problem.
     * 
     */
    @JsonProperty("detail")
    public String getDetail() {
        return detail;
    }

    /**
     * A human-readable explanation specific to this occurrence of the problem.
     * 
     */
    @JsonProperty("detail")
    public void setDetail(String detail) {
        this.detail = detail;
    }

    /**
     * A URI reference [RFC3986] that identifies the problem type.
     * 
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * A URI reference [RFC3986] that identifies the problem type.
     * 
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * A short, human-readable summary of the problem type.
     * (Required)
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * A short, human-readable summary of the problem type.
     * (Required)
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * The HTTP status code.
     * (Required)
     * 
     */
    @JsonProperty("status")
    public Integer getStatus() {
        return status;
    }

    /**
     * The HTTP status code.
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * A URI reference that identifies the specific occurrence of the problem.
     * 
     */
    @JsonProperty("instance")
    public String getInstance() {
        return instance;
    }

    /**
     * A URI reference that identifies the specific occurrence of the problem.
     * 
     */
    @JsonProperty("instance")
    public void setInstance(String instance) {
        this.instance = instance;
    }

    /**
     * The name of the error (typically a server exception class name).
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * The name of the error (typically a server exception class name).
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

}
