package io.apicurio.registry.types.webhooks;

import io.apicurio.registry.types.webhooks.beans.CompatibilityCheckerRequest;
import io.apicurio.registry.types.webhooks.beans.CompatibilityCheckerResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

/**
 * A JAX-RS interface. An implementation of this interface must be provided.
 */
@Path("/CompatibilityChecker")
public interface CompatibilityCheckerResource {
  @POST
  @Produces("application/json")
  @Consumes("application/json")
  CompatibilityCheckerResponse testCompatibility(@NotNull CompatibilityCheckerRequest data);
}
