package io.apicurio.registry.types.webhooks;

import io.apicurio.registry.types.webhooks.beans.ContentValidatorRequest;
import io.apicurio.registry.types.webhooks.beans.ContentValidatorResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

/**
 * A JAX-RS interface. An implementation of this interface must be provided.
 */
@Path("/ContentValidator")
public interface ContentValidatorResource {
  @POST
  @Produces("application/json")
  @Consumes("application/json")
  ContentValidatorResponse validate(@NotNull ContentValidatorRequest data);
}
