package io.apicurio.registry.types.webhooks;

import io.apicurio.registry.types.webhooks.beans.ReferenceFinderRequest;
import io.apicurio.registry.types.webhooks.beans.ReferenceFinderResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

/**
 * A JAX-RS interface. An implementation of this interface must be provided.
 */
@Path("/ReferenceFinder")
public interface ReferenceFinderResource {
  @POST
  @Produces("application/json")
  @Consumes("application/json")
  ReferenceFinderResponse findExternalReferences(@NotNull ReferenceFinderRequest data);
}
