/*
 * Copyright 2018 Sober Lemur S.r.l.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sejda.io;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

/**
 * {@link WritableByteChannel} that does nothing .
 * 
 * @author Andrea Vacondio
 *
 */
public class DevNullWritableByteChannel implements WritableByteChannel {

    private boolean open = true;

    @Override
    public boolean isOpen() {
        return open;
    }

    @Override
    public void close() {
        this.open = false;
    }

    @Override
    public int write(ByteBuffer src) {
        return src.remaining();
    }

}
