/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel complianceLevel='17.0' oSGiCompatible='true' basePackage='org.eclipse.fennec.ai.chat.completion.model' resource='XMI' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n \nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n \nSPDX-License-Identifier: EPL-2.0\n \nContributors:\n      Data In Motion - initial API and implementation'"
 * @generated
 */
@ProviderType
@EPackage(uri = GeminiChatCompletionPackage.eNS_URI, genModel = "/model/gemini-chat-completion.genmodel", genModelSourceLocations = {"model/gemini-chat-completion.genmodel","org.eclipse.fennec.ai.chat.completion.gemini.model/model/gemini-chat-completion.genmodel"}, ecore="/model/gemini-chat-completion.ecore", ecoreSourceLocations="/model/gemini-chat-completion.ecore")
public interface GeminiChatCompletionPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "geminichatcompletion";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://ai.fenne.eclipse.org/chatcompletion/gemini/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "geminichatcompletion";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GeminiChatCompletionPackage eINSTANCE = org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionRequestImpl <em>Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionRequestImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getGeminiChatCompletionRequest()
	 * @generated
	 */
	int GEMINI_CHAT_COMPLETION_REQUEST = 0;

	/**
	 * The feature id for the '<em><b>Contents</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS = 0;

	/**
	 * The feature id for the '<em><b>System Instruction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION = 1;

	/**
	 * The feature id for the '<em><b>Generation Config</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG = 2;

	/**
	 * The number of structural features of the '<em>Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_REQUEST_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_REQUEST_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.ContentImpl <em>Content</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.ContentImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getContent()
	 * @generated
	 */
	int CONTENT = 1;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__ROLE = 0;

	/**
	 * The feature id for the '<em><b>Parts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT__PARTS = 1;

	/**
	 * The number of structural features of the '<em>Content</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Content</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PartImpl <em>Part</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PartImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getPart()
	 * @generated
	 */
	int PART = 2;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PART__TEXT = 0;

	/**
	 * The number of structural features of the '<em>Part</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PART_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Part</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PART_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GenerationConfigImpl <em>Generation Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GenerationConfigImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getGenerationConfig()
	 * @generated
	 */
	int GENERATION_CONFIG = 3;

	/**
	 * The feature id for the '<em><b>Response Mime Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERATION_CONFIG__RESPONSE_MIME_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Response Json Schema</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERATION_CONFIG__RESPONSE_JSON_SCHEMA = 1;

	/**
	 * The number of structural features of the '<em>Generation Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERATION_CONFIG_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Generation Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERATION_CONFIG_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl <em>Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getGeminiChatCompletionResponse()
	 * @generated
	 */
	int GEMINI_CHAT_COMPLETION_RESPONSE = 4;

	/**
	 * The feature id for the '<em><b>Response Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID = 0;

	/**
	 * The feature id for the '<em><b>Model Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION = 1;

	/**
	 * The feature id for the '<em><b>Candidates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES = 2;

	/**
	 * The feature id for the '<em><b>Usage Metadata</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA = 3;

	/**
	 * The number of structural features of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_RESPONSE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEMINI_CHAT_COMPLETION_RESPONSE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl <em>Usage Metadata</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getUsageMetadata()
	 * @generated
	 */
	int USAGE_METADATA = 5;

	/**
	 * The feature id for the '<em><b>Prompt Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_METADATA__PROMPT_TOKEN_COUNT = 0;

	/**
	 * The feature id for the '<em><b>Candidates Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_METADATA__CANDIDATES_TOKEN_COUNT = 1;

	/**
	 * The feature id for the '<em><b>Total Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_METADATA__TOTAL_TOKEN_COUNT = 2;

	/**
	 * The feature id for the '<em><b>Thoughts Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_METADATA__THOUGHTS_TOKEN_COUNT = 3;

	/**
	 * The feature id for the '<em><b>Prompt Tokens Details</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_METADATA__PROMPT_TOKENS_DETAILS = 4;

	/**
	 * The number of structural features of the '<em>Usage Metadata</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_METADATA_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Usage Metadata</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_METADATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PromptTokensDetailImpl <em>Prompt Tokens Detail</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PromptTokensDetailImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getPromptTokensDetail()
	 * @generated
	 */
	int PROMPT_TOKENS_DETAIL = 6;

	/**
	 * The feature id for the '<em><b>Modality</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKENS_DETAIL__MODALITY = 0;

	/**
	 * The feature id for the '<em><b>Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKENS_DETAIL__TOKEN_COUNT = 1;

	/**
	 * The number of structural features of the '<em>Prompt Tokens Detail</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKENS_DETAIL_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Prompt Tokens Detail</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKENS_DETAIL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.CandidateImpl <em>Candidate</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.CandidateImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getCandidate()
	 * @generated
	 */
	int CANDIDATE = 7;

	/**
	 * The feature id for the '<em><b>Finish Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CANDIDATE__FINISH_REASON = 0;

	/**
	 * The feature id for the '<em><b>Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CANDIDATE__INDEX = 1;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CANDIDATE__CONTENT = 2;

	/**
	 * The number of structural features of the '<em>Candidate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CANDIDATE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Candidate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CANDIDATE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.SystemInstructionImpl <em>System Instruction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.SystemInstructionImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getSystemInstruction()
	 * @generated
	 */
	int SYSTEM_INSTRUCTION = 8;

	/**
	 * The feature id for the '<em><b>Parts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_INSTRUCTION__PARTS = 0;

	/**
	 * The number of structural features of the '<em>System Instruction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_INSTRUCTION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>System Instruction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_INSTRUCTION_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest <em>Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Request</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest
	 * @generated
	 */
	EClass getGeminiChatCompletionRequest();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getContents <em>Contents</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contents</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getContents()
	 * @see #getGeminiChatCompletionRequest()
	 * @generated
	 */
	EReference getGeminiChatCompletionRequest_Contents();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getSystemInstruction <em>System Instruction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>System Instruction</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getSystemInstruction()
	 * @see #getGeminiChatCompletionRequest()
	 * @generated
	 */
	EReference getGeminiChatCompletionRequest_SystemInstruction();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getGenerationConfig <em>Generation Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Generation Config</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getGenerationConfig()
	 * @see #getGeminiChatCompletionRequest()
	 * @generated
	 */
	EReference getGeminiChatCompletionRequest_GenerationConfig();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Content</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content
	 * @generated
	 */
	EClass getContent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content#getRole()
	 * @see #getContent()
	 * @generated
	 */
	EAttribute getContent_Role();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content#getParts <em>Parts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parts</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content#getParts()
	 * @see #getContent()
	 * @generated
	 */
	EReference getContent_Parts();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Part <em>Part</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Part</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Part
	 * @generated
	 */
	EClass getPart();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Part#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Part#getText()
	 * @see #getPart()
	 * @generated
	 */
	EAttribute getPart_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig <em>Generation Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generation Config</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig
	 * @generated
	 */
	EClass getGenerationConfig();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseMimeType <em>Response Mime Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Response Mime Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseMimeType()
	 * @see #getGenerationConfig()
	 * @generated
	 */
	EAttribute getGenerationConfig_ResponseMimeType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseJsonSchema <em>Response Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Response Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseJsonSchema()
	 * @see #getGenerationConfig()
	 * @generated
	 */
	EReference getGenerationConfig_ResponseJsonSchema();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse <em>Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Response</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse
	 * @generated
	 */
	EClass getGeminiChatCompletionResponse();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getResponseId <em>Response Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Response Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getResponseId()
	 * @see #getGeminiChatCompletionResponse()
	 * @generated
	 */
	EAttribute getGeminiChatCompletionResponse_ResponseId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getModelVersion <em>Model Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model Version</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getModelVersion()
	 * @see #getGeminiChatCompletionResponse()
	 * @generated
	 */
	EAttribute getGeminiChatCompletionResponse_ModelVersion();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getCandidates <em>Candidates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Candidates</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getCandidates()
	 * @see #getGeminiChatCompletionResponse()
	 * @generated
	 */
	EReference getGeminiChatCompletionResponse_Candidates();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getUsageMetadata <em>Usage Metadata</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Usage Metadata</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getUsageMetadata()
	 * @see #getGeminiChatCompletionResponse()
	 * @generated
	 */
	EReference getGeminiChatCompletionResponse_UsageMetadata();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata <em>Usage Metadata</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Usage Metadata</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata
	 * @generated
	 */
	EClass getUsageMetadata();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getPromptTokenCount <em>Prompt Token Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Prompt Token Count</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getPromptTokenCount()
	 * @see #getUsageMetadata()
	 * @generated
	 */
	EAttribute getUsageMetadata_PromptTokenCount();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getCandidatesTokenCount <em>Candidates Token Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Candidates Token Count</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getCandidatesTokenCount()
	 * @see #getUsageMetadata()
	 * @generated
	 */
	EAttribute getUsageMetadata_CandidatesTokenCount();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getTotalTokenCount <em>Total Token Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Token Count</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getTotalTokenCount()
	 * @see #getUsageMetadata()
	 * @generated
	 */
	EAttribute getUsageMetadata_TotalTokenCount();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getThoughtsTokenCount <em>Thoughts Token Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Thoughts Token Count</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getThoughtsTokenCount()
	 * @see #getUsageMetadata()
	 * @generated
	 */
	EAttribute getUsageMetadata_ThoughtsTokenCount();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getPromptTokensDetails <em>Prompt Tokens Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Prompt Tokens Details</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getPromptTokensDetails()
	 * @see #getUsageMetadata()
	 * @generated
	 */
	EReference getUsageMetadata_PromptTokensDetails();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail <em>Prompt Tokens Detail</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Prompt Tokens Detail</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail
	 * @generated
	 */
	EClass getPromptTokensDetail();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getModality <em>Modality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Modality</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getModality()
	 * @see #getPromptTokensDetail()
	 * @generated
	 */
	EAttribute getPromptTokensDetail_Modality();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getTokenCount <em>Token Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Token Count</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getTokenCount()
	 * @see #getPromptTokensDetail()
	 * @generated
	 */
	EAttribute getPromptTokensDetail_TokenCount();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate <em>Candidate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Candidate</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate
	 * @generated
	 */
	EClass getCandidate();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate#getFinishReason <em>Finish Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Finish Reason</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate#getFinishReason()
	 * @see #getCandidate()
	 * @generated
	 */
	EAttribute getCandidate_FinishReason();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate#getIndex <em>Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Index</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate#getIndex()
	 * @see #getCandidate()
	 * @generated
	 */
	EAttribute getCandidate_Index();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Content</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate#getContent()
	 * @see #getCandidate()
	 * @generated
	 */
	EReference getCandidate_Content();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.SystemInstruction <em>System Instruction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>System Instruction</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.SystemInstruction
	 * @generated
	 */
	EClass getSystemInstruction();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.SystemInstruction#getParts <em>Parts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parts</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.SystemInstruction#getParts()
	 * @see #getSystemInstruction()
	 * @generated
	 */
	EReference getSystemInstruction_Parts();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	GeminiChatCompletionFactory getGeminiChatCompletionFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionRequestImpl <em>Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionRequestImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getGeminiChatCompletionRequest()
		 * @generated
		 */
		EClass GEMINI_CHAT_COMPLETION_REQUEST = eINSTANCE.getGeminiChatCompletionRequest();

		/**
		 * The meta object literal for the '<em><b>Contents</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS = eINSTANCE.getGeminiChatCompletionRequest_Contents();

		/**
		 * The meta object literal for the '<em><b>System Instruction</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION = eINSTANCE.getGeminiChatCompletionRequest_SystemInstruction();

		/**
		 * The meta object literal for the '<em><b>Generation Config</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG = eINSTANCE.getGeminiChatCompletionRequest_GenerationConfig();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.ContentImpl <em>Content</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.ContentImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getContent()
		 * @generated
		 */
		EClass CONTENT = eINSTANCE.getContent();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTENT__ROLE = eINSTANCE.getContent_Role();

		/**
		 * The meta object literal for the '<em><b>Parts</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTENT__PARTS = eINSTANCE.getContent_Parts();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PartImpl <em>Part</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PartImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getPart()
		 * @generated
		 */
		EClass PART = eINSTANCE.getPart();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PART__TEXT = eINSTANCE.getPart_Text();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GenerationConfigImpl <em>Generation Config</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GenerationConfigImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getGenerationConfig()
		 * @generated
		 */
		EClass GENERATION_CONFIG = eINSTANCE.getGenerationConfig();

		/**
		 * The meta object literal for the '<em><b>Response Mime Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GENERATION_CONFIG__RESPONSE_MIME_TYPE = eINSTANCE.getGenerationConfig_ResponseMimeType();

		/**
		 * The meta object literal for the '<em><b>Response Json Schema</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GENERATION_CONFIG__RESPONSE_JSON_SCHEMA = eINSTANCE.getGenerationConfig_ResponseJsonSchema();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl <em>Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getGeminiChatCompletionResponse()
		 * @generated
		 */
		EClass GEMINI_CHAT_COMPLETION_RESPONSE = eINSTANCE.getGeminiChatCompletionResponse();

		/**
		 * The meta object literal for the '<em><b>Response Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID = eINSTANCE.getGeminiChatCompletionResponse_ResponseId();

		/**
		 * The meta object literal for the '<em><b>Model Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION = eINSTANCE.getGeminiChatCompletionResponse_ModelVersion();

		/**
		 * The meta object literal for the '<em><b>Candidates</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES = eINSTANCE.getGeminiChatCompletionResponse_Candidates();

		/**
		 * The meta object literal for the '<em><b>Usage Metadata</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA = eINSTANCE.getGeminiChatCompletionResponse_UsageMetadata();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl <em>Usage Metadata</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getUsageMetadata()
		 * @generated
		 */
		EClass USAGE_METADATA = eINSTANCE.getUsageMetadata();

		/**
		 * The meta object literal for the '<em><b>Prompt Token Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE_METADATA__PROMPT_TOKEN_COUNT = eINSTANCE.getUsageMetadata_PromptTokenCount();

		/**
		 * The meta object literal for the '<em><b>Candidates Token Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE_METADATA__CANDIDATES_TOKEN_COUNT = eINSTANCE.getUsageMetadata_CandidatesTokenCount();

		/**
		 * The meta object literal for the '<em><b>Total Token Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE_METADATA__TOTAL_TOKEN_COUNT = eINSTANCE.getUsageMetadata_TotalTokenCount();

		/**
		 * The meta object literal for the '<em><b>Thoughts Token Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE_METADATA__THOUGHTS_TOKEN_COUNT = eINSTANCE.getUsageMetadata_ThoughtsTokenCount();

		/**
		 * The meta object literal for the '<em><b>Prompt Tokens Details</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USAGE_METADATA__PROMPT_TOKENS_DETAILS = eINSTANCE.getUsageMetadata_PromptTokensDetails();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PromptTokensDetailImpl <em>Prompt Tokens Detail</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.PromptTokensDetailImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getPromptTokensDetail()
		 * @generated
		 */
		EClass PROMPT_TOKENS_DETAIL = eINSTANCE.getPromptTokensDetail();

		/**
		 * The meta object literal for the '<em><b>Modality</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROMPT_TOKENS_DETAIL__MODALITY = eINSTANCE.getPromptTokensDetail_Modality();

		/**
		 * The meta object literal for the '<em><b>Token Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROMPT_TOKENS_DETAIL__TOKEN_COUNT = eINSTANCE.getPromptTokensDetail_TokenCount();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.CandidateImpl <em>Candidate</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.CandidateImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getCandidate()
		 * @generated
		 */
		EClass CANDIDATE = eINSTANCE.getCandidate();

		/**
		 * The meta object literal for the '<em><b>Finish Reason</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CANDIDATE__FINISH_REASON = eINSTANCE.getCandidate_FinishReason();

		/**
		 * The meta object literal for the '<em><b>Index</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CANDIDATE__INDEX = eINSTANCE.getCandidate_Index();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CANDIDATE__CONTENT = eINSTANCE.getCandidate_Content();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.SystemInstructionImpl <em>System Instruction</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.SystemInstructionImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionPackageImpl#getSystemInstruction()
		 * @generated
		 */
		EClass SYSTEM_INSTRUCTION = eINSTANCE.getSystemInstruction();

		/**
		 * The meta object literal for the '<em><b>Parts</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SYSTEM_INSTRUCTION__PARTS = eINSTANCE.getSystemInstruction_Parts();

	}

} //GeminiChatCompletionPackage
