/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Request</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getContents <em>Contents</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getSystemInstruction <em>System Instruction</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getGenerationConfig <em>Generation Config</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionRequest()
 * @model
 * @generated
 */
@ProviderType
public interface GeminiChatCompletionRequest extends EObject {
	/**
	 * Returns the value of the '<em><b>Contents</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Contents</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionRequest_Contents()
	 * @model containment="true"
	 * @generated
	 */
	EList<Content> getContents();

	/**
	 * Returns the value of the '<em><b>System Instruction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>System Instruction</em>' containment reference.
	 * @see #setSystemInstruction(SystemInstruction)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionRequest_SystemInstruction()
	 * @model containment="true"
	 *        annotation="JsonProperty value='system_instruction'"
	 * @generated
	 */
	SystemInstruction getSystemInstruction();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getSystemInstruction <em>System Instruction</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>System Instruction</em>' containment reference.
	 * @see #getSystemInstruction()
	 * @generated
	 */
	void setSystemInstruction(SystemInstruction value);

	/**
	 * Returns the value of the '<em><b>Generation Config</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Generation Config</em>' containment reference.
	 * @see #setGenerationConfig(GenerationConfig)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionRequest_GenerationConfig()
	 * @model containment="true"
	 * @generated
	 */
	GenerationConfig getGenerationConfig();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest#getGenerationConfig <em>Generation Config</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Generation Config</em>' containment reference.
	 * @see #getGenerationConfig()
	 * @generated
	 */
	void setGenerationConfig(GenerationConfig value);

} // GeminiChatCompletionRequest
