/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Response</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getResponseId <em>Response Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getModelVersion <em>Model Version</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getCandidates <em>Candidates</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getUsageMetadata <em>Usage Metadata</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionResponse()
 * @model
 * @generated
 */
@ProviderType
public interface GeminiChatCompletionResponse extends EObject {
	/**
	 * Returns the value of the '<em><b>Response Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Response Id</em>' attribute.
	 * @see #setResponseId(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionResponse_ResponseId()
	 * @model
	 * @generated
	 */
	String getResponseId();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getResponseId <em>Response Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Response Id</em>' attribute.
	 * @see #getResponseId()
	 * @generated
	 */
	void setResponseId(String value);

	/**
	 * Returns the value of the '<em><b>Model Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Model Version</em>' attribute.
	 * @see #setModelVersion(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionResponse_ModelVersion()
	 * @model
	 * @generated
	 */
	String getModelVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getModelVersion <em>Model Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model Version</em>' attribute.
	 * @see #getModelVersion()
	 * @generated
	 */
	void setModelVersion(String value);

	/**
	 * Returns the value of the '<em><b>Candidates</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Candidates</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionResponse_Candidates()
	 * @model containment="true"
	 * @generated
	 */
	EList<Candidate> getCandidates();

	/**
	 * Returns the value of the '<em><b>Usage Metadata</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Usage Metadata</em>' containment reference.
	 * @see #setUsageMetadata(UsageMetadata)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGeminiChatCompletionResponse_UsageMetadata()
	 * @model containment="true"
	 * @generated
	 */
	UsageMetadata getUsageMetadata();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse#getUsageMetadata <em>Usage Metadata</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Usage Metadata</em>' containment reference.
	 * @see #getUsageMetadata()
	 * @generated
	 */
	void setUsageMetadata(UsageMetadata value);

} // GeminiChatCompletionResponse
