/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Generation Config</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseMimeType <em>Response Mime Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseJsonSchema <em>Response Json Schema</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGenerationConfig()
 * @model
 * @generated
 */
@ProviderType
public interface GenerationConfig extends EObject {
	/**
	 * Returns the value of the '<em><b>Response Mime Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Response Mime Type</em>' attribute.
	 * @see #setResponseMimeType(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGenerationConfig_ResponseMimeType()
	 * @model annotation="JsonProperty value='response_mime_type'"
	 * @generated
	 */
	String getResponseMimeType();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseMimeType <em>Response Mime Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Response Mime Type</em>' attribute.
	 * @see #getResponseMimeType()
	 * @generated
	 */
	void setResponseMimeType(String value);

	/**
	 * Returns the value of the '<em><b>Response Json Schema</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Response Json Schema</em>' containment reference.
	 * @see #setResponseJsonSchema(JsonSchema)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getGenerationConfig_ResponseJsonSchema()
	 * @model containment="true"
	 *        annotation="JsonProperty value='response_json_schema'"
	 * @generated
	 */
	JsonSchema getResponseJsonSchema();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig#getResponseJsonSchema <em>Response Json Schema</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Response Json Schema</em>' containment reference.
	 * @see #getResponseJsonSchema()
	 * @generated
	 */
	void setResponseJsonSchema(JsonSchema value);

} // GenerationConfig
