/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Prompt Tokens Detail</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getModality <em>Modality</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getTokenCount <em>Token Count</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getPromptTokensDetail()
 * @model
 * @generated
 */
@ProviderType
public interface PromptTokensDetail extends EObject {
	/**
	 * Returns the value of the '<em><b>Modality</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Modality</em>' attribute.
	 * @see #setModality(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getPromptTokensDetail_Modality()
	 * @model
	 * @generated
	 */
	String getModality();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getModality <em>Modality</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Modality</em>' attribute.
	 * @see #getModality()
	 * @generated
	 */
	void setModality(String value);

	/**
	 * Returns the value of the '<em><b>Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Token Count</em>' attribute.
	 * @see #setTokenCount(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getPromptTokensDetail_TokenCount()
	 * @model
	 * @generated
	 */
	int getTokenCount();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail#getTokenCount <em>Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Token Count</em>' attribute.
	 * @see #getTokenCount()
	 * @generated
	 */
	void setTokenCount(int value);

} // PromptTokensDetail
