/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Usage Metadata</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getPromptTokenCount <em>Prompt Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getCandidatesTokenCount <em>Candidates Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getTotalTokenCount <em>Total Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getThoughtsTokenCount <em>Thoughts Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getPromptTokensDetails <em>Prompt Tokens Details</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getUsageMetadata()
 * @model
 * @generated
 */
@ProviderType
public interface UsageMetadata extends EObject {
	/**
	 * Returns the value of the '<em><b>Prompt Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Prompt Token Count</em>' attribute.
	 * @see #setPromptTokenCount(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getUsageMetadata_PromptTokenCount()
	 * @model
	 * @generated
	 */
	int getPromptTokenCount();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getPromptTokenCount <em>Prompt Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Prompt Token Count</em>' attribute.
	 * @see #getPromptTokenCount()
	 * @generated
	 */
	void setPromptTokenCount(int value);

	/**
	 * Returns the value of the '<em><b>Candidates Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Candidates Token Count</em>' attribute.
	 * @see #setCandidatesTokenCount(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getUsageMetadata_CandidatesTokenCount()
	 * @model
	 * @generated
	 */
	int getCandidatesTokenCount();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getCandidatesTokenCount <em>Candidates Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Candidates Token Count</em>' attribute.
	 * @see #getCandidatesTokenCount()
	 * @generated
	 */
	void setCandidatesTokenCount(int value);

	/**
	 * Returns the value of the '<em><b>Total Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Total Token Count</em>' attribute.
	 * @see #setTotalTokenCount(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getUsageMetadata_TotalTokenCount()
	 * @model
	 * @generated
	 */
	int getTotalTokenCount();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getTotalTokenCount <em>Total Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Token Count</em>' attribute.
	 * @see #getTotalTokenCount()
	 * @generated
	 */
	void setTotalTokenCount(int value);

	/**
	 * Returns the value of the '<em><b>Thoughts Token Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Thoughts Token Count</em>' attribute.
	 * @see #setThoughtsTokenCount(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getUsageMetadata_ThoughtsTokenCount()
	 * @model
	 * @generated
	 */
	int getThoughtsTokenCount();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata#getThoughtsTokenCount <em>Thoughts Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Thoughts Token Count</em>' attribute.
	 * @see #getThoughtsTokenCount()
	 * @generated
	 */
	void setThoughtsTokenCount(int value);

	/**
	 * Returns the value of the '<em><b>Prompt Tokens Details</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Prompt Tokens Details</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#getUsageMetadata_PromptTokensDetails()
	 * @model containment="true"
	 * @generated
	 */
	EList<PromptTokensDetail> getPromptTokensDetails();

} // UsageMetadata
